package org.graylog.plugins.netflow.v9;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RawNetFlowV9Packet extends RawNetFlowV9Packet {

  private final NetFlowV9Header header;

  private final int dataLength;

  private final Map<Integer, byte[]> templates;

  private final Map.Entry<Integer, byte[]> optionTemplate;

  private final Set<Integer> usedTemplates;

  AutoValue_RawNetFlowV9Packet(
      NetFlowV9Header header,
      int dataLength,
      Map<Integer, byte[]> templates,
      @Nullable Map.Entry<Integer, byte[]> optionTemplate,
      Set<Integer> usedTemplates) {
    if (header == null) {
      throw new NullPointerException("Null header");
    }
    this.header = header;
    this.dataLength = dataLength;
    if (templates == null) {
      throw new NullPointerException("Null templates");
    }
    this.templates = templates;
    this.optionTemplate = optionTemplate;
    if (usedTemplates == null) {
      throw new NullPointerException("Null usedTemplates");
    }
    this.usedTemplates = usedTemplates;
  }

  @Override
  public NetFlowV9Header header() {
    return header;
  }

  @Override
  public int dataLength() {
    return dataLength;
  }

  @Override
  public Map<Integer, byte[]> templates() {
    return templates;
  }

  @Nullable
  @Override
  public Map.Entry<Integer, byte[]> optionTemplate() {
    return optionTemplate;
  }

  @Override
  public Set<Integer> usedTemplates() {
    return usedTemplates;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RawNetFlowV9Packet) {
      RawNetFlowV9Packet that = (RawNetFlowV9Packet) o;
      return this.header.equals(that.header())
          && this.dataLength == that.dataLength()
          && this.templates.equals(that.templates())
          && (this.optionTemplate == null ? that.optionTemplate() == null : this.optionTemplate.equals(that.optionTemplate()))
          && this.usedTemplates.equals(that.usedTemplates());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= header.hashCode();
    h$ *= 1000003;
    h$ ^= dataLength;
    h$ *= 1000003;
    h$ ^= templates.hashCode();
    h$ *= 1000003;
    h$ ^= (optionTemplate == null) ? 0 : optionTemplate.hashCode();
    h$ *= 1000003;
    h$ ^= usedTemplates.hashCode();
    return h$;
  }

}
