package org.graylog.plugins.sidecar.rest.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog2.database.PaginatedList;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SidecarListResponse extends SidecarListResponse {

  private final String query;

  private final PaginatedList.PaginationInfo paginationInfo;

  private final long total;

  private final Boolean onlyActive;

  private final String sort;

  private final String order;

  private final Collection<SidecarSummary> sidecars;

  private final Map<String, String> filters;

  AutoValue_SidecarListResponse(
      @Nullable String query,
      PaginatedList.PaginationInfo paginationInfo,
      long total,
      Boolean onlyActive,
      @Nullable String sort,
      @Nullable String order,
      Collection<SidecarSummary> sidecars,
      @Nullable Map<String, String> filters) {
    this.query = query;
    if (paginationInfo == null) {
      throw new NullPointerException("Null paginationInfo");
    }
    this.paginationInfo = paginationInfo;
    this.total = total;
    if (onlyActive == null) {
      throw new NullPointerException("Null onlyActive");
    }
    this.onlyActive = onlyActive;
    this.sort = sort;
    this.order = order;
    if (sidecars == null) {
      throw new NullPointerException("Null sidecars");
    }
    this.sidecars = sidecars;
    this.filters = filters;
  }

  @Nullable
  @JsonProperty
  @Override
  public String query() {
    return query;
  }

  @JsonProperty("pagination")
  @Override
  public PaginatedList.PaginationInfo paginationInfo() {
    return paginationInfo;
  }

  @JsonProperty
  @Override
  public long total() {
    return total;
  }

  @JsonProperty
  @Override
  public Boolean onlyActive() {
    return onlyActive;
  }

  @Nullable
  @JsonProperty
  @Override
  public String sort() {
    return sort;
  }

  @Nullable
  @JsonProperty
  @Override
  public String order() {
    return order;
  }

  @JsonProperty
  @Override
  public Collection<SidecarSummary> sidecars() {
    return sidecars;
  }

  @Nullable
  @JsonProperty
  @Override
  public Map<String, String> filters() {
    return filters;
  }

  @Override
  public String toString() {
    return "SidecarListResponse{"
        + "query=" + query + ", "
        + "paginationInfo=" + paginationInfo + ", "
        + "total=" + total + ", "
        + "onlyActive=" + onlyActive + ", "
        + "sort=" + sort + ", "
        + "order=" + order + ", "
        + "sidecars=" + sidecars + ", "
        + "filters=" + filters
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SidecarListResponse) {
      SidecarListResponse that = (SidecarListResponse) o;
      return (this.query == null ? that.query() == null : this.query.equals(that.query()))
          && this.paginationInfo.equals(that.paginationInfo())
          && this.total == that.total()
          && this.onlyActive.equals(that.onlyActive())
          && (this.sort == null ? that.sort() == null : this.sort.equals(that.sort()))
          && (this.order == null ? that.order() == null : this.order.equals(that.order()))
          && this.sidecars.equals(that.sidecars())
          && (this.filters == null ? that.filters() == null : this.filters.equals(that.filters()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (query == null) ? 0 : query.hashCode();
    h$ *= 1000003;
    h$ ^= paginationInfo.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((total >>> 32) ^ total);
    h$ *= 1000003;
    h$ ^= onlyActive.hashCode();
    h$ *= 1000003;
    h$ ^= (sort == null) ? 0 : sort.hashCode();
    h$ *= 1000003;
    h$ ^= (order == null) ? 0 : order.hashCode();
    h$ *= 1000003;
    h$ ^= sidecars.hashCode();
    h$ *= 1000003;
    h$ ^= (filters == null) ? 0 : filters.hashCode();
    return h$;
  }

}
