package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessageList extends MessageList {

  private final String id;

  private final Optional<TimeRange> timerange;

  private final Optional<ElasticsearchQueryString> query;

  private final Set<String> streams;

  private final Optional<String> name;

  private final int limit;

  private final int offset;

  private final List<Sort> sort;

  private AutoValue_MessageList(
      String id,
      Optional<TimeRange> timerange,
      Optional<ElasticsearchQueryString> query,
      Set<String> streams,
      Optional<String> name,
      int limit,
      int offset,
      @Nullable List<Sort> sort) {
    this.id = id;
    this.timerange = timerange;
    this.query = query;
    this.streams = streams;
    this.name = name;
    this.limit = limit;
    this.offset = offset;
    this.sort = sort;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<ElasticsearchQueryString> query() {
    return query;
  }

  @JsonProperty
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @JsonProperty
  @Override
  int limit() {
    return limit;
  }

  @JsonProperty
  @Override
  int offset() {
    return offset;
  }

  @Nullable
  @Override
  List<Sort> sort() {
    return sort;
  }

  @Override
  public String toString() {
    return "MessageList{"
        + "id=" + id + ", "
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "streams=" + streams + ", "
        + "name=" + name + ", "
        + "limit=" + limit + ", "
        + "offset=" + offset + ", "
        + "sort=" + sort
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessageList) {
      MessageList that = (MessageList) o;
      return this.id.equals(that.id())
          && this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.streams.equals(that.streams())
          && this.name.equals(that.name())
          && this.limit == that.limit()
          && this.offset == that.offset()
          && (this.sort == null ? that.sort() == null : this.sort.equals(that.sort()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= limit;
    h$ *= 1000003;
    h$ ^= offset;
    h$ *= 1000003;
    h$ ^= (sort == null) ? 0 : sort.hashCode();
    return h$;
  }

  @Override
  MessageList.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MessageList.Builder {
    private String id;
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<ElasticsearchQueryString> query = Optional.empty();
    private Set<String> streams;
    private Optional<String> name = Optional.empty();
    private Integer limit;
    private Integer offset;
    private List<Sort> sort;
    Builder() {
    }
    private Builder(MessageList source) {
      this.id = source.id();
      this.timerange = source.timerange();
      this.query = source.query();
      this.streams = source.streams();
      this.name = source.name();
      this.limit = source.limit();
      this.offset = source.offset();
      this.sort = source.sort();
    }
    @Override
    MessageList.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    MessageList.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    MessageList.Builder query(@Nullable ElasticsearchQueryString query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    MessageList.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    MessageList.Builder name(@Nullable String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }
    @Override
    MessageList.Builder limit(int limit) {
      this.limit = limit;
      return this;
    }
    @Override
    MessageList.Builder offset(int offset) {
      this.offset = offset;
      return this;
    }
    @Override
    MessageList.Builder sort(@Nullable List<Sort> sort) {
      this.sort = sort;
      return this;
    }
    @Override
    MessageList build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.limit == null) {
        missing += " limit";
      }
      if (this.offset == null) {
        missing += " offset";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessageList(
          this.id,
          this.timerange,
          this.query,
          this.streams,
          this.name,
          this.limit,
          this.offset,
          this.sort);
    }
  }

}
