package org.graylog.plugins.views.search.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Filter;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_OrFilter extends OrFilter {

  private final String type;

  private final Set<Filter> filters;

  private AutoValue_OrFilter(
      String type,
      Set<Filter> filters) {
    this.type = type;
    this.filters = filters;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public Set<Filter> filters() {
    return filters;
  }

  @Override
  public String toString() {
    return "OrFilter{"
        + "type=" + type + ", "
        + "filters=" + filters
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OrFilter) {
      OrFilter that = (OrFilter) o;
      return this.type.equals(that.type())
          && this.filters.equals(that.filters());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= filters.hashCode();
    return h$;
  }

  @Override
  public OrFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends OrFilter.Builder {
    private String type;
    private Set<Filter> filters;
    Builder() {
    }
    private Builder(OrFilter source) {
      this.type = source.type();
      this.filters = source.filters();
    }
    @Override
    public OrFilter.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public OrFilter.Builder filters(Set<Filter> filters) {
      if (filters == null) {
        throw new NullPointerException("Null filters");
      }
      this.filters = filters;
      return this;
    }
    @Override
    public OrFilter build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.filters == null) {
        missing += " filters";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_OrFilter(
          this.type,
          this.filters);
    }
  }

}
