package org.graylog.plugins.views.search.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Filter;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryStringFilter extends QueryStringFilter {

  private final String type;

  private final Set<Filter> filters;

  private final String query;

  private AutoValue_QueryStringFilter(
      String type,
      @Nullable Set<Filter> filters,
      String query) {
    this.type = type;
    this.filters = filters;
    this.query = query;
  }

  @Override
  public String type() {
    return type;
  }

  @Nullable
  @JsonProperty
  @Override
  public Set<Filter> filters() {
    return filters;
  }

  @JsonProperty("query")
  @Override
  public String query() {
    return query;
  }

  @Override
  public String toString() {
    return "QueryStringFilter{"
        + "type=" + type + ", "
        + "filters=" + filters + ", "
        + "query=" + query
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryStringFilter) {
      QueryStringFilter that = (QueryStringFilter) o;
      return this.type.equals(that.type())
          && (this.filters == null ? that.filters() == null : this.filters.equals(that.filters()))
          && this.query.equals(that.query());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (filters == null) ? 0 : filters.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    return h$;
  }

  @Override
  public QueryStringFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryStringFilter.Builder {
    private String type;
    private Set<Filter> filters;
    private String query;
    Builder() {
    }
    private Builder(QueryStringFilter source) {
      this.type = source.type();
      this.filters = source.filters();
      this.query = source.query();
    }
    @Override
    public QueryStringFilter.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public QueryStringFilter.Builder filters(@Nullable Set<Filter> filters) {
      this.filters = filters;
      return this;
    }
    @Override
    public QueryStringFilter.Builder query(String query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public QueryStringFilter build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryStringFilter(
          this.type,
          this.filters,
          this.query);
    }
  }

}
