package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExecutionStateGlobalOverride extends ExecutionStateGlobalOverride {

  private final Optional<TimeRange> timerange;

  private final Optional<BackendQuery> query;

  private final Optional<Integer> limit;

  private final Optional<Integer> offset;

  private final ImmutableMap<String, SearchTypeExecutionState> searchTypes;

  private final ImmutableSet<String> keepSearchTypes;

  private final ImmutableSet<String> keepQueries;

  private AutoValue_ExecutionStateGlobalOverride(
      Optional<TimeRange> timerange,
      Optional<BackendQuery> query,
      Optional<Integer> limit,
      Optional<Integer> offset,
      ImmutableMap<String, SearchTypeExecutionState> searchTypes,
      ImmutableSet<String> keepSearchTypes,
      ImmutableSet<String> keepQueries) {
    this.timerange = timerange;
    this.query = query;
    this.limit = limit;
    this.offset = offset;
    this.searchTypes = searchTypes;
    this.keepSearchTypes = keepSearchTypes;
    this.keepQueries = keepQueries;
  }

  @JsonProperty
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @JsonProperty
  @Override
  public Optional<Integer> limit() {
    return limit;
  }

  @JsonProperty
  @Override
  public Optional<Integer> offset() {
    return offset;
  }

  @JsonProperty
  @Override
  public ImmutableMap<String, SearchTypeExecutionState> searchTypes() {
    return searchTypes;
  }

  @JsonProperty
  @Override
  public ImmutableSet<String> keepSearchTypes() {
    return keepSearchTypes;
  }

  @JsonProperty
  @Override
  public ImmutableSet<String> keepQueries() {
    return keepQueries;
  }

  @Override
  public String toString() {
    return "ExecutionStateGlobalOverride{"
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "limit=" + limit + ", "
        + "offset=" + offset + ", "
        + "searchTypes=" + searchTypes + ", "
        + "keepSearchTypes=" + keepSearchTypes + ", "
        + "keepQueries=" + keepQueries
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExecutionStateGlobalOverride) {
      ExecutionStateGlobalOverride that = (ExecutionStateGlobalOverride) o;
      return this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.limit.equals(that.limit())
          && this.offset.equals(that.offset())
          && this.searchTypes.equals(that.searchTypes())
          && this.keepSearchTypes.equals(that.keepSearchTypes())
          && this.keepQueries.equals(that.keepQueries());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= offset.hashCode();
    h$ *= 1000003;
    h$ ^= searchTypes.hashCode();
    h$ *= 1000003;
    h$ ^= keepSearchTypes.hashCode();
    h$ *= 1000003;
    h$ ^= keepQueries.hashCode();
    return h$;
  }

  @Override
  public ExecutionStateGlobalOverride.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ExecutionStateGlobalOverride.Builder {
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<BackendQuery> query = Optional.empty();
    private Optional<Integer> limit = Optional.empty();
    private Optional<Integer> offset = Optional.empty();
    private ImmutableMap.Builder<String, SearchTypeExecutionState> searchTypesBuilder$;
    private ImmutableMap<String, SearchTypeExecutionState> searchTypes;
    private ImmutableSet.Builder<String> keepSearchTypesBuilder$;
    private ImmutableSet<String> keepSearchTypes;
    private ImmutableSet.Builder<String> keepQueriesBuilder$;
    private ImmutableSet<String> keepQueries;
    Builder() {
    }
    private Builder(ExecutionStateGlobalOverride source) {
      this.timerange = source.timerange();
      this.query = source.query();
      this.limit = source.limit();
      this.offset = source.offset();
      this.searchTypes = source.searchTypes();
      this.keepSearchTypes = source.keepSearchTypes();
      this.keepQueries = source.keepQueries();
    }
    @Override
    public ExecutionStateGlobalOverride.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder limit(@Nullable Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder offset(@Nullable Integer offset) {
      this.offset = Optional.ofNullable(offset);
      return this;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder searchTypes(ImmutableMap<String, SearchTypeExecutionState> searchTypes) {
      if (searchTypes == null) {
        throw new NullPointerException("Null searchTypes");
      }
      if (searchTypesBuilder$ != null) {
        throw new IllegalStateException("Cannot set searchTypes after calling searchTypesBuilder()");
      }
      this.searchTypes = searchTypes;
      return this;
    }
    @Override
    public ImmutableMap.Builder<String, SearchTypeExecutionState> searchTypesBuilder() {
      if (searchTypesBuilder$ == null) {
        if (searchTypes == null) {
          searchTypesBuilder$ = ImmutableMap.builder();
        } else {
          searchTypesBuilder$ = ImmutableMap.builder();
          searchTypesBuilder$.putAll(searchTypes);
          searchTypes = null;
        }
      }
      return searchTypesBuilder$;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder keepSearchTypes(ImmutableSet<String> keepSearchTypes) {
      if (keepSearchTypes == null) {
        throw new NullPointerException("Null keepSearchTypes");
      }
      if (keepSearchTypesBuilder$ != null) {
        throw new IllegalStateException("Cannot set keepSearchTypes after calling keepSearchTypesBuilder()");
      }
      this.keepSearchTypes = keepSearchTypes;
      return this;
    }
    @Override
    public ImmutableSet.Builder<String> keepSearchTypesBuilder() {
      if (keepSearchTypesBuilder$ == null) {
        if (keepSearchTypes == null) {
          keepSearchTypesBuilder$ = ImmutableSet.builder();
        } else {
          keepSearchTypesBuilder$ = ImmutableSet.builder();
          keepSearchTypesBuilder$.addAll(keepSearchTypes);
          keepSearchTypes = null;
        }
      }
      return keepSearchTypesBuilder$;
    }
    @Override
    public ExecutionStateGlobalOverride.Builder keepQueries(ImmutableSet<String> keepQueries) {
      if (keepQueries == null) {
        throw new NullPointerException("Null keepQueries");
      }
      if (keepQueriesBuilder$ != null) {
        throw new IllegalStateException("Cannot set keepQueries after calling keepQueriesBuilder()");
      }
      this.keepQueries = keepQueries;
      return this;
    }
    @Override
    public ImmutableSet.Builder<String> keepQueriesBuilder() {
      if (keepQueriesBuilder$ == null) {
        if (keepQueries == null) {
          keepQueriesBuilder$ = ImmutableSet.builder();
        } else {
          keepQueriesBuilder$ = ImmutableSet.builder();
          keepQueriesBuilder$.addAll(keepQueries);
          keepQueries = null;
        }
      }
      return keepQueriesBuilder$;
    }
    @Override
    public ExecutionStateGlobalOverride build() {
      if (searchTypesBuilder$ != null) {
        this.searchTypes = searchTypesBuilder$.build();
      } else if (this.searchTypes == null) {
        this.searchTypes = ImmutableMap.of();
      }
      if (keepSearchTypesBuilder$ != null) {
        this.keepSearchTypes = keepSearchTypesBuilder$.build();
      } else if (this.keepSearchTypes == null) {
        this.keepSearchTypes = ImmutableSet.of();
      }
      if (keepQueriesBuilder$ != null) {
        this.keepQueries = keepQueriesBuilder$.build();
      } else if (this.keepQueries == null) {
        this.keepQueries = ImmutableSet.of();
      }
      return new AutoValue_ExecutionStateGlobalOverride(
          this.timerange,
          this.query,
          this.limit,
          this.offset,
          this.searchTypes,
          this.keepSearchTypes,
          this.keepQueries);
    }
  }

}
