package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.Parameter;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SearchDTO extends SearchDTO {

  private final String id;

  private final LinkedHashSet<QueryDTO> queries;

  private final Set<Parameter> parameters;

  private AutoValue_SearchDTO(
      @Nullable String id,
      LinkedHashSet<QueryDTO> queries,
      Set<Parameter> parameters) {
    this.id = id;
    this.queries = queries;
    this.parameters = parameters;
  }

  @Nullable
  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public LinkedHashSet<QueryDTO> queries() {
    return queries;
  }

  @JsonProperty
  @Override
  public Set<Parameter> parameters() {
    return parameters;
  }

  @Override
  public String toString() {
    return "SearchDTO{"
        + "id=" + id + ", "
        + "queries=" + queries + ", "
        + "parameters=" + parameters
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchDTO) {
      SearchDTO that = (SearchDTO) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.queries.equals(that.queries())
          && this.parameters.equals(that.parameters());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= queries.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    return h$;
  }

  static final class Builder extends SearchDTO.Builder {
    private String id;
    private LinkedHashSet<QueryDTO> queries;
    private Set<Parameter> parameters;
    Builder() {
    }
    @Override
    public SearchDTO.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    @Nullable public String id() {
      return id;
    }
    @Override
    public SearchDTO.Builder queries(LinkedHashSet<QueryDTO> queries) {
      if (queries == null) {
        throw new NullPointerException("Null queries");
      }
      this.queries = queries;
      return this;
    }
    @Override
    public SearchDTO.Builder parameters(Set<Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public SearchDTO build() {
      String missing = "";
      if (this.queries == null) {
        missing += " queries";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SearchDTO(
          this.id,
          this.queries,
          this.parameters);
    }
  }

}
