package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.errors.SearchError;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SearchJobDTO extends SearchJobDTO {

  private final String id;

  private final String searchId;

  private final String owner;

  private final Set<SearchError> errors;

  private final Map<String, QueryResult> results;

  private final SearchJobDTO.ExecutionInfo execution;

  private AutoValue_SearchJobDTO(
      String id,
      String searchId,
      String owner,
      Set<SearchError> errors,
      Map<String, QueryResult> results,
      SearchJobDTO.ExecutionInfo execution) {
    this.id = id;
    this.searchId = searchId;
    this.owner = owner;
    this.errors = errors;
    this.results = results;
    this.execution = execution;
  }

  @JsonProperty
  @Override
  String id() {
    return id;
  }

  @JsonProperty("search_id")
  @Override
  String searchId() {
    return searchId;
  }

  @JsonProperty
  @Override
  String owner() {
    return owner;
  }

  @JsonProperty("errors")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  Set<SearchError> errors() {
    return errors;
  }

  @JsonProperty
  @Override
  public Map<String, QueryResult> results() {
    return results;
  }

  @JsonProperty
  @Override
  SearchJobDTO.ExecutionInfo execution() {
    return execution;
  }

  @Override
  public String toString() {
    return "SearchJobDTO{"
        + "id=" + id + ", "
        + "searchId=" + searchId + ", "
        + "owner=" + owner + ", "
        + "errors=" + errors + ", "
        + "results=" + results + ", "
        + "execution=" + execution
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchJobDTO) {
      SearchJobDTO that = (SearchJobDTO) o;
      return this.id.equals(that.id())
          && this.searchId.equals(that.searchId())
          && this.owner.equals(that.owner())
          && this.errors.equals(that.errors())
          && this.results.equals(that.results())
          && this.execution.equals(that.execution());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= searchId.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= errors.hashCode();
    h$ *= 1000003;
    h$ ^= results.hashCode();
    h$ *= 1000003;
    h$ ^= execution.hashCode();
    return h$;
  }

  static final class Builder extends SearchJobDTO.Builder {
    private String id;
    private String searchId;
    private String owner;
    private Set<SearchError> errors;
    private Map<String, QueryResult> results;
    private SearchJobDTO.ExecutionInfo execution;
    Builder() {
    }
    @Override
    SearchJobDTO.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    SearchJobDTO.Builder searchId(String searchId) {
      if (searchId == null) {
        throw new NullPointerException("Null searchId");
      }
      this.searchId = searchId;
      return this;
    }
    @Override
    SearchJobDTO.Builder owner(String owner) {
      if (owner == null) {
        throw new NullPointerException("Null owner");
      }
      this.owner = owner;
      return this;
    }
    @Override
    SearchJobDTO.Builder errors(Set<SearchError> errors) {
      if (errors == null) {
        throw new NullPointerException("Null errors");
      }
      this.errors = errors;
      return this;
    }
    @Override
    SearchJobDTO.Builder results(Map<String, QueryResult> results) {
      if (results == null) {
        throw new NullPointerException("Null results");
      }
      this.results = results;
      return this;
    }
    @Override
    SearchJobDTO.Builder execution(SearchJobDTO.ExecutionInfo execution) {
      if (execution == null) {
        throw new NullPointerException("Null execution");
      }
      this.execution = execution;
      return this;
    }
    @Override
    SearchJobDTO build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.searchId == null) {
        missing += " searchId";
      }
      if (this.owner == null) {
        missing += " owner";
      }
      if (this.errors == null) {
        missing += " errors";
      }
      if (this.results == null) {
        missing += " results";
      }
      if (this.execution == null) {
        missing += " execution";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SearchJobDTO(
          this.id,
          this.searchId,
          this.owner,
          this.errors,
          this.results,
          this.execution);
    }
  }

}
