package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValidationMessageDTO extends ValidationMessageDTO {

  private final ValidationTypeDTO errorType;

  private final Integer beginLine;

  private final Integer beginColumn;

  private final Integer endLine;

  private final Integer endColumn;

  private final String errorTitle;

  private final String errorMessage;

  private final String relatedProperty;

  private AutoValue_ValidationMessageDTO(
      ValidationTypeDTO errorType,
      @Nullable Integer beginLine,
      @Nullable Integer beginColumn,
      @Nullable Integer endLine,
      @Nullable Integer endColumn,
      @Nullable String errorTitle,
      String errorMessage,
      @Nullable String relatedProperty) {
    this.errorType = errorType;
    this.beginLine = beginLine;
    this.beginColumn = beginColumn;
    this.endLine = endLine;
    this.endColumn = endColumn;
    this.errorTitle = errorTitle;
    this.errorMessage = errorMessage;
    this.relatedProperty = relatedProperty;
  }

  @JsonProperty
  @Override
  public ValidationTypeDTO errorType() {
    return errorType;
  }

  @JsonProperty
  @Nullable
  @Override
  public Integer beginLine() {
    return beginLine;
  }

  @JsonProperty
  @Nullable
  @Override
  public Integer beginColumn() {
    return beginColumn;
  }

  @JsonProperty
  @Nullable
  @Override
  public Integer endLine() {
    return endLine;
  }

  @JsonProperty
  @Nullable
  @Override
  public Integer endColumn() {
    return endColumn;
  }

  @JsonProperty
  @Nullable
  @Override
  public String errorTitle() {
    return errorTitle;
  }

  @JsonProperty
  @Override
  public String errorMessage() {
    return errorMessage;
  }

  @Nullable
  @JsonProperty
  @Override
  public String relatedProperty() {
    return relatedProperty;
  }

  @Override
  public String toString() {
    return "ValidationMessageDTO{"
        + "errorType=" + errorType + ", "
        + "beginLine=" + beginLine + ", "
        + "beginColumn=" + beginColumn + ", "
        + "endLine=" + endLine + ", "
        + "endColumn=" + endColumn + ", "
        + "errorTitle=" + errorTitle + ", "
        + "errorMessage=" + errorMessage + ", "
        + "relatedProperty=" + relatedProperty
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidationMessageDTO) {
      ValidationMessageDTO that = (ValidationMessageDTO) o;
      return this.errorType.equals(that.errorType())
          && (this.beginLine == null ? that.beginLine() == null : this.beginLine.equals(that.beginLine()))
          && (this.beginColumn == null ? that.beginColumn() == null : this.beginColumn.equals(that.beginColumn()))
          && (this.endLine == null ? that.endLine() == null : this.endLine.equals(that.endLine()))
          && (this.endColumn == null ? that.endColumn() == null : this.endColumn.equals(that.endColumn()))
          && (this.errorTitle == null ? that.errorTitle() == null : this.errorTitle.equals(that.errorTitle()))
          && this.errorMessage.equals(that.errorMessage())
          && (this.relatedProperty == null ? that.relatedProperty() == null : this.relatedProperty.equals(that.relatedProperty()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= errorType.hashCode();
    h$ *= 1000003;
    h$ ^= (beginLine == null) ? 0 : beginLine.hashCode();
    h$ *= 1000003;
    h$ ^= (beginColumn == null) ? 0 : beginColumn.hashCode();
    h$ *= 1000003;
    h$ ^= (endLine == null) ? 0 : endLine.hashCode();
    h$ *= 1000003;
    h$ ^= (endColumn == null) ? 0 : endColumn.hashCode();
    h$ *= 1000003;
    h$ ^= (errorTitle == null) ? 0 : errorTitle.hashCode();
    h$ *= 1000003;
    h$ ^= errorMessage.hashCode();
    h$ *= 1000003;
    h$ ^= (relatedProperty == null) ? 0 : relatedProperty.hashCode();
    return h$;
  }

  static final class Builder extends ValidationMessageDTO.Builder {
    private ValidationTypeDTO errorType;
    private Integer beginLine;
    private Integer beginColumn;
    private Integer endLine;
    private Integer endColumn;
    private String errorTitle;
    private String errorMessage;
    private String relatedProperty;
    Builder() {
    }
    @Override
    public ValidationMessageDTO.Builder errorType(ValidationTypeDTO errorType) {
      if (errorType == null) {
        throw new NullPointerException("Null errorType");
      }
      this.errorType = errorType;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder beginLine(int beginLine) {
      this.beginLine = beginLine;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder beginColumn(int beginColumn) {
      this.beginColumn = beginColumn;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder endLine(int endLine) {
      this.endLine = endLine;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder endColumn(int endColumn) {
      this.endColumn = endColumn;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder errorTitle(String errorTitle) {
      this.errorTitle = errorTitle;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder errorMessage(String errorMessage) {
      if (errorMessage == null) {
        throw new NullPointerException("Null errorMessage");
      }
      this.errorMessage = errorMessage;
      return this;
    }
    @Override
    public ValidationMessageDTO.Builder relatedProperty(String relatedProperty) {
      this.relatedProperty = relatedProperty;
      return this;
    }
    @Override
    public ValidationMessageDTO build() {
      String missing = "";
      if (this.errorType == null) {
        missing += " errorType";
      }
      if (this.errorMessage == null) {
        missing += " errorMessage";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidationMessageDTO(
          this.errorType,
          this.beginLine,
          this.beginColumn,
          this.endLine,
          this.endColumn,
          this.errorTitle,
          this.errorMessage,
          this.relatedProperty);
    }
  }

}
