package org.graylog.plugins.views.search.validation;

import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValidationContext extends ValidationContext {

  private final ValidationRequest request;

  private final ParsedQuery query;

  private final Set<MappedFieldTypeDTO> availableFields;

  private AutoValue_ValidationContext(
      ValidationRequest request,
      ParsedQuery query,
      Set<MappedFieldTypeDTO> availableFields) {
    this.request = request;
    this.query = query;
    this.availableFields = availableFields;
  }

  @Override
  public ValidationRequest request() {
    return request;
  }

  @Override
  public ParsedQuery query() {
    return query;
  }

  @Override
  public Set<MappedFieldTypeDTO> availableFields() {
    return availableFields;
  }

  @Override
  public String toString() {
    return "ValidationContext{"
        + "request=" + request + ", "
        + "query=" + query + ", "
        + "availableFields=" + availableFields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidationContext) {
      ValidationContext that = (ValidationContext) o;
      return this.request.equals(that.request())
          && this.query.equals(that.query())
          && this.availableFields.equals(that.availableFields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= request.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= availableFields.hashCode();
    return h$;
  }

  static final class Builder extends ValidationContext.Builder {
    private ValidationRequest request;
    private ParsedQuery query;
    private Set<MappedFieldTypeDTO> availableFields;
    Builder() {
    }
    @Override
    public ValidationContext.Builder request(ValidationRequest request) {
      if (request == null) {
        throw new NullPointerException("Null request");
      }
      this.request = request;
      return this;
    }
    @Override
    public ValidationContext.Builder query(ParsedQuery query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public ValidationContext.Builder availableFields(Set<MappedFieldTypeDTO> availableFields) {
      if (availableFields == null) {
        throw new NullPointerException("Null availableFields");
      }
      this.availableFields = availableFields;
      return this;
    }
    @Override
    public ValidationContext build() {
      String missing = "";
      if (this.request == null) {
        missing += " request";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (this.availableFields == null) {
        missing += " availableFields";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidationContext(
          this.request,
          this.query,
          this.availableFields);
    }
  }

}
