package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotBlank;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ViewDTO extends ViewDTO {

  private final String id;

  private final ViewDTO.Type type;

  private final @NotBlank String title;

  private final String summary;

  private final String description;

  private final String searchId;

  private final ImmutableSet<String> properties;

  private final Map<String, PluginMetadataSummary> requires;

  private final Map<String, ViewStateDTO> state;

  private final Optional<String> owner;

  private final DateTime createdAt;

  private final boolean favorite;

  $AutoValue_ViewDTO(
      @Nullable String id,
      ViewDTO.Type type,
      @NotBlank String title,
      String summary,
      String description,
      String searchId,
      ImmutableSet<String> properties,
      Map<String, PluginMetadataSummary> requires,
      Map<String, ViewStateDTO> state,
      Optional<String> owner,
      DateTime createdAt,
      boolean favorite) {
    this.id = id;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    if (summary == null) {
      throw new NullPointerException("Null summary");
    }
    this.summary = summary;
    if (description == null) {
      throw new NullPointerException("Null description");
    }
    this.description = description;
    if (searchId == null) {
      throw new NullPointerException("Null searchId");
    }
    this.searchId = searchId;
    if (properties == null) {
      throw new NullPointerException("Null properties");
    }
    this.properties = properties;
    if (requires == null) {
      throw new NullPointerException("Null requires");
    }
    this.requires = requires;
    if (state == null) {
      throw new NullPointerException("Null state");
    }
    this.state = state;
    if (owner == null) {
      throw new NullPointerException("Null owner");
    }
    this.owner = owner;
    if (createdAt == null) {
      throw new NullPointerException("Null createdAt");
    }
    this.createdAt = createdAt;
    this.favorite = favorite;
  }

  @ObjectId
  @Id
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("type")
  @Override
  public ViewDTO.Type type() {
    return type;
  }

  @JsonProperty("title")
  @Override
  public @NotBlank String title() {
    return title;
  }

  @JsonProperty("summary")
  @Override
  public String summary() {
    return summary;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("search_id")
  @Override
  public String searchId() {
    return searchId;
  }

  @JsonProperty("properties")
  @Override
  public ImmutableSet<String> properties() {
    return properties;
  }

  @JsonProperty("requires")
  @Override
  public Map<String, PluginMetadataSummary> requires() {
    return requires;
  }

  @JsonProperty("state")
  @Override
  public Map<String, ViewStateDTO> state() {
    return state;
  }

  @JsonProperty("owner")
  @Override
  public Optional<String> owner() {
    return owner;
  }

  @JsonProperty("created_at")
  @Override
  public DateTime createdAt() {
    return createdAt;
  }

  @JsonProperty("favorite")
  @MongoIgnore
  @Override
  public boolean favorite() {
    return favorite;
  }

  @Override
  public String toString() {
    return "ViewDTO{"
        + "id=" + id + ", "
        + "type=" + type + ", "
        + "title=" + title + ", "
        + "summary=" + summary + ", "
        + "description=" + description + ", "
        + "searchId=" + searchId + ", "
        + "properties=" + properties + ", "
        + "requires=" + requires + ", "
        + "state=" + state + ", "
        + "owner=" + owner + ", "
        + "createdAt=" + createdAt + ", "
        + "favorite=" + favorite
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ViewDTO) {
      ViewDTO that = (ViewDTO) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.type.equals(that.type())
          && this.title.equals(that.title())
          && this.summary.equals(that.summary())
          && this.description.equals(that.description())
          && this.searchId.equals(that.searchId())
          && this.properties.equals(that.properties())
          && this.requires.equals(that.requires())
          && this.state.equals(that.state())
          && this.owner.equals(that.owner())
          && this.createdAt.equals(that.createdAt())
          && this.favorite == that.favorite();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= summary.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= searchId.hashCode();
    h$ *= 1000003;
    h$ ^= properties.hashCode();
    h$ *= 1000003;
    h$ ^= requires.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= favorite ? 1231 : 1237;
    return h$;
  }

  @Override
  public ViewDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends ViewDTO.Builder {
    private String id;
    private ViewDTO.Type type;
    private @NotBlank String title;
    private String summary;
    private String description;
    private String searchId;
    private ImmutableSet.Builder<String> propertiesBuilder$;
    private ImmutableSet<String> properties;
    private Map<String, PluginMetadataSummary> requires;
    private Map<String, ViewStateDTO> state;
    private Optional<String> owner = Optional.empty();
    private DateTime createdAt;
    private Boolean favorite;
    Builder() {
    }
    private Builder(ViewDTO source) {
      this.id = source.id();
      this.type = source.type();
      this.title = source.title();
      this.summary = source.summary();
      this.description = source.description();
      this.searchId = source.searchId();
      this.properties = source.properties();
      this.requires = source.requires();
      this.state = source.state();
      this.owner = source.owner();
      this.createdAt = source.createdAt();
      this.favorite = source.favorite();
    }
    @Override
    public ViewDTO.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public ViewDTO.Builder type(ViewDTO.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ViewDTO.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public ViewDTO.Builder summary(String summary) {
      if (summary == null) {
        throw new NullPointerException("Null summary");
      }
      this.summary = summary;
      return this;
    }
    @Override
    public ViewDTO.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public ViewDTO.Builder searchId(String searchId) {
      if (searchId == null) {
        throw new NullPointerException("Null searchId");
      }
      this.searchId = searchId;
      return this;
    }
    @Override
    ImmutableSet.Builder<String> propertiesBuilder() {
      if (propertiesBuilder$ == null) {
        if (properties == null) {
          propertiesBuilder$ = ImmutableSet.builder();
        } else {
          propertiesBuilder$ = ImmutableSet.builder();
          propertiesBuilder$.addAll(properties);
          properties = null;
        }
      }
      return propertiesBuilder$;
    }
    @Override
    public ViewDTO.Builder requires(Map<String, PluginMetadataSummary> requires) {
      if (requires == null) {
        throw new NullPointerException("Null requires");
      }
      this.requires = requires;
      return this;
    }
    @Override
    public ViewDTO.Builder state(Map<String, ViewStateDTO> state) {
      if (state == null) {
        throw new NullPointerException("Null state");
      }
      this.state = state;
      return this;
    }
    @Override
    public ViewDTO.Builder owner(@Nullable String owner) {
      this.owner = Optional.ofNullable(owner);
      return this;
    }
    @Override
    public ViewDTO.Builder createdAt(DateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public ViewDTO.Builder favorite(boolean favorite) {
      this.favorite = favorite;
      return this;
    }
    @Override
    public ViewDTO build() {
      if (propertiesBuilder$ != null) {
        this.properties = propertiesBuilder$.build();
      } else if (this.properties == null) {
        this.properties = ImmutableSet.of();
      }
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.title == null) {
        missing += " title";
      }
      if (this.summary == null) {
        missing += " summary";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.searchId == null) {
        missing += " searchId";
      }
      if (this.requires == null) {
        missing += " requires";
      }
      if (this.state == null) {
        missing += " state";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (this.favorite == null) {
        missing += " favorite";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ViewDTO(
          this.id,
          this.type,
          this.title,
          this.summary,
          this.description,
          this.searchId,
          this.properties,
          this.requires,
          this.state,
          this.owner,
          this.createdAt,
          this.favorite);
    }
  }

}
