package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_WidgetDTO extends WidgetDTO {

  private final String id;

  private final String type;

  private final String filter;

  private final List<UsedSearchFilter> filters;

  private final Optional<TimeRange> timerange;

  private final Optional<BackendQuery> query;

  private final Set<String> streams;

  private final WidgetConfigDTO config;

  $AutoValue_WidgetDTO(
      String id,
      String type,
      @Nullable String filter,
      List<UsedSearchFilter> filters,
      Optional<TimeRange> timerange,
      Optional<BackendQuery> query,
      Set<String> streams,
      WidgetConfigDTO config) {
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    this.filter = filter;
    if (filters == null) {
      throw new NullPointerException("Null filters");
    }
    this.filters = filters;
    if (timerange == null) {
      throw new NullPointerException("Null timerange");
    }
    this.timerange = timerange;
    if (query == null) {
      throw new NullPointerException("Null query");
    }
    this.query = query;
    if (streams == null) {
      throw new NullPointerException("Null streams");
    }
    this.streams = streams;
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("filter")
  @Nullable
  @Override
  public String filter() {
    return filter;
  }

  @JsonProperty("filters")
  @Override
  public List<UsedSearchFilter> filters() {
    return filters;
  }

  @JsonProperty("timerange")
  @Override
  public Optional<TimeRange> timerange() {
    return timerange;
  }

  @JsonProperty("query")
  @Override
  public Optional<BackendQuery> query() {
    return query;
  }

  @JsonProperty("streams")
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty("config")
  @Override
  public WidgetConfigDTO config() {
    return config;
  }

  @Override
  public String toString() {
    return "WidgetDTO{"
        + "id=" + id + ", "
        + "type=" + type + ", "
        + "filter=" + filter + ", "
        + "filters=" + filters + ", "
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "streams=" + streams + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof WidgetDTO) {
      WidgetDTO that = (WidgetDTO) o;
      return this.id.equals(that.id())
          && this.type.equals(that.type())
          && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()))
          && this.filters.equals(that.filters())
          && this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.streams.equals(that.streams())
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (filter == null) ? 0 : filter.hashCode();
    h$ *= 1000003;
    h$ ^= filters.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  @Override
  public WidgetDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends WidgetDTO.Builder {
    private String id;
    private String type;
    private String filter;
    private List<UsedSearchFilter> filters;
    private Optional<TimeRange> timerange = Optional.empty();
    private Optional<BackendQuery> query = Optional.empty();
    private Set<String> streams;
    private WidgetConfigDTO config;
    Builder() {
    }
    private Builder(WidgetDTO source) {
      this.id = source.id();
      this.type = source.type();
      this.filter = source.filter();
      this.filters = source.filters();
      this.timerange = source.timerange();
      this.query = source.query();
      this.streams = source.streams();
      this.config = source.config();
    }
    @Override
    public WidgetDTO.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public WidgetDTO.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public WidgetDTO.Builder filter(@Nullable String filter) {
      this.filter = filter;
      return this;
    }
    @Override
    public WidgetDTO.Builder filters(List<UsedSearchFilter> filters) {
      if (filters == null) {
        throw new NullPointerException("Null filters");
      }
      this.filters = filters;
      return this;
    }
    @Override
    public WidgetDTO.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = Optional.ofNullable(timerange);
      return this;
    }
    @Override
    public WidgetDTO.Builder query(@Nullable BackendQuery query) {
      this.query = Optional.ofNullable(query);
      return this;
    }
    @Override
    public WidgetDTO.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public WidgetDTO.Builder config(WidgetConfigDTO config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public WidgetDTO build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.filters == null) {
        missing += " filters";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_WidgetDTO(
          this.id,
          this.type,
          this.filter,
          this.filters,
          this.timerange,
          this.query,
          this.streams,
          this.config);
    }
  }

}
