package org.graylog.plugins.views.search.views.widgets.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HeatmapVisualizationConfigDTO extends HeatmapVisualizationConfigDTO {

  private final String colorScale;

  private final boolean reverseScale;

  private final boolean autoScale;

  private final Optional<String> zMin;

  private final Optional<String> zMax;

  private final Optional<Long> defaultValue;

  private final boolean useSmallestAsDefault;

  private AutoValue_HeatmapVisualizationConfigDTO(
      String colorScale,
      boolean reverseScale,
      boolean autoScale,
      Optional<String> zMin,
      Optional<String> zMax,
      Optional<Long> defaultValue,
      boolean useSmallestAsDefault) {
    this.colorScale = colorScale;
    this.reverseScale = reverseScale;
    this.autoScale = autoScale;
    this.zMin = zMin;
    this.zMax = zMax;
    this.defaultValue = defaultValue;
    this.useSmallestAsDefault = useSmallestAsDefault;
  }

  @JsonProperty("color_scale")
  @Override
  public String colorScale() {
    return colorScale;
  }

  @JsonProperty("reverse_scale")
  @Override
  public boolean reverseScale() {
    return reverseScale;
  }

  @JsonProperty("auto_scale")
  @Override
  public boolean autoScale() {
    return autoScale;
  }

  @JsonProperty("z_min")
  @Override
  public Optional<String> zMin() {
    return zMin;
  }

  @JsonProperty("z_max")
  @Override
  public Optional<String> zMax() {
    return zMax;
  }

  @JsonProperty("default_value")
  @Override
  public Optional<Long> defaultValue() {
    return defaultValue;
  }

  @JsonProperty("use_smallest_as_default")
  @Override
  public boolean useSmallestAsDefault() {
    return useSmallestAsDefault;
  }

  @Override
  public String toString() {
    return "HeatmapVisualizationConfigDTO{"
        + "colorScale=" + colorScale + ", "
        + "reverseScale=" + reverseScale + ", "
        + "autoScale=" + autoScale + ", "
        + "zMin=" + zMin + ", "
        + "zMax=" + zMax + ", "
        + "defaultValue=" + defaultValue + ", "
        + "useSmallestAsDefault=" + useSmallestAsDefault
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HeatmapVisualizationConfigDTO) {
      HeatmapVisualizationConfigDTO that = (HeatmapVisualizationConfigDTO) o;
      return this.colorScale.equals(that.colorScale())
          && this.reverseScale == that.reverseScale()
          && this.autoScale == that.autoScale()
          && this.zMin.equals(that.zMin())
          && this.zMax.equals(that.zMax())
          && this.defaultValue.equals(that.defaultValue())
          && this.useSmallestAsDefault == that.useSmallestAsDefault();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= colorScale.hashCode();
    h$ *= 1000003;
    h$ ^= reverseScale ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= autoScale ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= zMin.hashCode();
    h$ *= 1000003;
    h$ ^= zMax.hashCode();
    h$ *= 1000003;
    h$ ^= defaultValue.hashCode();
    h$ *= 1000003;
    h$ ^= useSmallestAsDefault ? 1231 : 1237;
    return h$;
  }

  @Override
  public HeatmapVisualizationConfigDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends HeatmapVisualizationConfigDTO.Builder {
    private String colorScale;
    private Boolean reverseScale;
    private Boolean autoScale;
    private Optional<String> zMin = Optional.empty();
    private Optional<String> zMax = Optional.empty();
    private Optional<Long> defaultValue = Optional.empty();
    private Boolean useSmallestAsDefault;
    Builder() {
    }
    private Builder(HeatmapVisualizationConfigDTO source) {
      this.colorScale = source.colorScale();
      this.reverseScale = source.reverseScale();
      this.autoScale = source.autoScale();
      this.zMin = source.zMin();
      this.zMax = source.zMax();
      this.defaultValue = source.defaultValue();
      this.useSmallestAsDefault = source.useSmallestAsDefault();
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder colorScale(String colorScale) {
      if (colorScale == null) {
        throw new NullPointerException("Null colorScale");
      }
      this.colorScale = colorScale;
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder reverseScale(boolean reverseScale) {
      this.reverseScale = reverseScale;
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder autoScale(boolean autoScale) {
      this.autoScale = autoScale;
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder zMin(@Nullable String zMin) {
      this.zMin = Optional.ofNullable(zMin);
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder zMax(@Nullable String zMax) {
      this.zMax = Optional.ofNullable(zMax);
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder defaultValue(@Nullable Long defaultValue) {
      this.defaultValue = Optional.ofNullable(defaultValue);
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO.Builder useSmallestAsDefault(boolean useSmallestAsDefault) {
      this.useSmallestAsDefault = useSmallestAsDefault;
      return this;
    }
    @Override
    public HeatmapVisualizationConfigDTO build() {
      String missing = "";
      if (this.colorScale == null) {
        missing += " colorScale";
      }
      if (this.reverseScale == null) {
        missing += " reverseScale";
      }
      if (this.autoScale == null) {
        missing += " autoScale";
      }
      if (this.useSmallestAsDefault == null) {
        missing += " useSmallestAsDefault";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_HeatmapVisualizationConfigDTO(
          this.colorScale,
          this.reverseScale,
          this.autoScale,
          this.zMin,
          this.zMax,
          this.defaultValue,
          this.useSmallestAsDefault);
    }
  }

}
