package org.graylog.plugins.views.search.views.widgets.messagelist;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.views.widgets.aggregation.sort.SortConfigDTO;
import org.graylog2.decorators.Decorator;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessageListConfigDTO extends MessageListConfigDTO {

  private final ImmutableSet<String> fields;

  private final boolean showMessageRow;

  private final Boolean showSummary;

  private final List<Decorator> decorators;

  private final List<SortConfigDTO> sort;

  private AutoValue_MessageListConfigDTO(
      ImmutableSet<String> fields,
      boolean showMessageRow,
      @Nullable Boolean showSummary,
      List<Decorator> decorators,
      List<SortConfigDTO> sort) {
    this.fields = fields;
    this.showMessageRow = showMessageRow;
    this.showSummary = showSummary;
    this.decorators = decorators;
    this.sort = sort;
  }

  @JsonProperty("fields")
  @Override
  public ImmutableSet<String> fields() {
    return fields;
  }

  @JsonProperty("show_message_row")
  @Override
  public boolean showMessageRow() {
    return showMessageRow;
  }

  @JsonProperty("show_summary")
  @Nullable
  @Override
  public Boolean showSummary() {
    return showSummary;
  }

  @JsonProperty("decorators")
  @Override
  public List<Decorator> decorators() {
    return decorators;
  }

  @JsonProperty("sort")
  @Override
  public List<SortConfigDTO> sort() {
    return sort;
  }

  @Override
  public String toString() {
    return "MessageListConfigDTO{"
        + "fields=" + fields + ", "
        + "showMessageRow=" + showMessageRow + ", "
        + "showSummary=" + showSummary + ", "
        + "decorators=" + decorators + ", "
        + "sort=" + sort
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessageListConfigDTO) {
      MessageListConfigDTO that = (MessageListConfigDTO) o;
      return this.fields.equals(that.fields())
          && this.showMessageRow == that.showMessageRow()
          && (this.showSummary == null ? that.showSummary() == null : this.showSummary.equals(that.showSummary()))
          && this.decorators.equals(that.decorators())
          && this.sort.equals(that.sort());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= showMessageRow ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (showSummary == null) ? 0 : showSummary.hashCode();
    h$ *= 1000003;
    h$ ^= decorators.hashCode();
    h$ *= 1000003;
    h$ ^= sort.hashCode();
    return h$;
  }

  static final class Builder extends MessageListConfigDTO.Builder {
    private ImmutableSet<String> fields;
    private Boolean showMessageRow;
    private Boolean showSummary;
    private List<Decorator> decorators;
    private List<SortConfigDTO> sort;
    Builder() {
    }
    @Override
    public MessageListConfigDTO.Builder fields(ImmutableSet<String> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public MessageListConfigDTO.Builder showMessageRow(boolean showMessageRow) {
      this.showMessageRow = showMessageRow;
      return this;
    }
    @Override
    public MessageListConfigDTO.Builder showSummary(Boolean showSummary) {
      this.showSummary = showSummary;
      return this;
    }
    @Override
    public MessageListConfigDTO.Builder decorators(List<Decorator> decorators) {
      if (decorators == null) {
        throw new NullPointerException("Null decorators");
      }
      this.decorators = decorators;
      return this;
    }
    @Override
    public MessageListConfigDTO.Builder sort(List<SortConfigDTO> sort) {
      if (sort == null) {
        throw new NullPointerException("Null sort");
      }
      this.sort = sort;
      return this;
    }
    @Override
    public MessageListConfigDTO build() {
      String missing = "";
      if (this.fields == null) {
        missing += " fields";
      }
      if (this.showMessageRow == null) {
        missing += " showMessageRow";
      }
      if (this.decorators == null) {
        missing += " decorators";
      }
      if (this.sort == null) {
        missing += " sort";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessageListConfigDTO(
          this.fields,
          this.showMessageRow,
          this.showSummary,
          this.decorators,
          this.sort);
    }
  }

}
