package org.graylog.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_JobExecutionContext extends JobExecutionContext {

  private final JobTriggerDto trigger;

  private final JobDefinitionDto definition;

  private final JobTriggerUpdates jobTriggerUpdates;

  private final AtomicBoolean schedulerIsRunning;

  private final DBJobTriggerService jobTriggerService;

  private AutoValue_JobExecutionContext(
      JobTriggerDto trigger,
      JobDefinitionDto definition,
      JobTriggerUpdates jobTriggerUpdates,
      AtomicBoolean schedulerIsRunning,
      DBJobTriggerService jobTriggerService) {
    this.trigger = trigger;
    this.definition = definition;
    this.jobTriggerUpdates = jobTriggerUpdates;
    this.schedulerIsRunning = schedulerIsRunning;
    this.jobTriggerService = jobTriggerService;
  }

  @Override
  public JobTriggerDto trigger() {
    return trigger;
  }

  @Override
  public JobDefinitionDto definition() {
    return definition;
  }

  @Override
  public JobTriggerUpdates jobTriggerUpdates() {
    return jobTriggerUpdates;
  }

  @Override
  public AtomicBoolean schedulerIsRunning() {
    return schedulerIsRunning;
  }

  @Override
  DBJobTriggerService jobTriggerService() {
    return jobTriggerService;
  }

  @Override
  public String toString() {
    return "JobExecutionContext{"
        + "trigger=" + trigger + ", "
        + "definition=" + definition + ", "
        + "jobTriggerUpdates=" + jobTriggerUpdates + ", "
        + "schedulerIsRunning=" + schedulerIsRunning + ", "
        + "jobTriggerService=" + jobTriggerService
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JobExecutionContext) {
      JobExecutionContext that = (JobExecutionContext) o;
      return this.trigger.equals(that.trigger())
          && this.definition.equals(that.definition())
          && this.jobTriggerUpdates.equals(that.jobTriggerUpdates())
          && this.schedulerIsRunning.equals(that.schedulerIsRunning())
          && this.jobTriggerService.equals(that.jobTriggerService());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= trigger.hashCode();
    h$ *= 1000003;
    h$ ^= definition.hashCode();
    h$ *= 1000003;
    h$ ^= jobTriggerUpdates.hashCode();
    h$ *= 1000003;
    h$ ^= schedulerIsRunning.hashCode();
    h$ *= 1000003;
    h$ ^= jobTriggerService.hashCode();
    return h$;
  }

  @Override
  public JobExecutionContext.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends JobExecutionContext.Builder {
    private JobTriggerDto trigger;
    private JobDefinitionDto definition;
    private JobTriggerUpdates jobTriggerUpdates;
    private AtomicBoolean schedulerIsRunning;
    private DBJobTriggerService jobTriggerService;
    Builder() {
    }
    private Builder(JobExecutionContext source) {
      this.trigger = source.trigger();
      this.definition = source.definition();
      this.jobTriggerUpdates = source.jobTriggerUpdates();
      this.schedulerIsRunning = source.schedulerIsRunning();
      this.jobTriggerService = source.jobTriggerService();
    }
    @Override
    public JobExecutionContext.Builder trigger(JobTriggerDto trigger) {
      if (trigger == null) {
        throw new NullPointerException("Null trigger");
      }
      this.trigger = trigger;
      return this;
    }
    @Override
    public JobExecutionContext.Builder definition(JobDefinitionDto definition) {
      if (definition == null) {
        throw new NullPointerException("Null definition");
      }
      this.definition = definition;
      return this;
    }
    @Override
    public JobExecutionContext.Builder jobTriggerUpdates(JobTriggerUpdates jobTriggerUpdates) {
      if (jobTriggerUpdates == null) {
        throw new NullPointerException("Null jobTriggerUpdates");
      }
      this.jobTriggerUpdates = jobTriggerUpdates;
      return this;
    }
    @Override
    public JobExecutionContext.Builder schedulerIsRunning(AtomicBoolean schedulerIsRunning) {
      if (schedulerIsRunning == null) {
        throw new NullPointerException("Null schedulerIsRunning");
      }
      this.schedulerIsRunning = schedulerIsRunning;
      return this;
    }
    @Override
    public JobExecutionContext.Builder jobTriggerService(DBJobTriggerService jobTriggerService) {
      if (jobTriggerService == null) {
        throw new NullPointerException("Null jobTriggerService");
      }
      this.jobTriggerService = jobTriggerService;
      return this;
    }
    @Override
    public JobExecutionContext build() {
      String missing = "";
      if (this.trigger == null) {
        missing += " trigger";
      }
      if (this.definition == null) {
        missing += " definition";
      }
      if (this.jobTriggerUpdates == null) {
        missing += " jobTriggerUpdates";
      }
      if (this.schedulerIsRunning == null) {
        missing += " schedulerIsRunning";
      }
      if (this.jobTriggerService == null) {
        missing += " jobTriggerService";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JobExecutionContext(
          this.trigger,
          this.definition,
          this.jobTriggerUpdates,
          this.schedulerIsRunning,
          this.jobTriggerService);
    }
  }

}
