package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

final class AutoValue_JobTriggerLock extends $AutoValue_JobTriggerLock {
  AutoValue_JobTriggerLock(String owner, String lastOwner, DateTime lastLockTime, long clock,
      int progress) {
    super(owner, lastOwner, lastLockTime, clock, progress);
  }

  @JsonIgnore
  @Nullable
  public final String getOwner() {
    return owner();
  }

  @JsonIgnore
  @Nullable
  public final String getLastOwner() {
    return lastOwner();
  }

  @JsonIgnore
  @Nullable
  public final DateTime getLastLockTime() {
    return lastLockTime();
  }

  @JsonIgnore
  public final long getClock() {
    return clock();
  }

  @JsonIgnore
  public final int getProgress() {
    return progress();
  }
}
