package org.graylog.scheduler.schedule;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CronJobSchedule extends CronJobSchedule {

  private final String type;

  private final String cronExpression;

  private final Optional<String> timezone;

  private AutoValue_CronJobSchedule(
      String type,
      String cronExpression,
      Optional<String> timezone) {
    this.type = type;
    this.cronExpression = cronExpression;
    this.timezone = timezone;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("cron_expression")
  @Override
  public String cronExpression() {
    return cronExpression;
  }

  @JsonProperty("timezone")
  @Override
  Optional<String> timezone() {
    return timezone;
  }

  @Override
  public String toString() {
    return "CronJobSchedule{"
        + "type=" + type + ", "
        + "cronExpression=" + cronExpression + ", "
        + "timezone=" + timezone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CronJobSchedule) {
      CronJobSchedule that = (CronJobSchedule) o;
      return this.type.equals(that.type())
          && this.cronExpression.equals(that.cronExpression())
          && this.timezone.equals(that.timezone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= cronExpression.hashCode();
    h$ *= 1000003;
    h$ ^= timezone.hashCode();
    return h$;
  }

  @Override
  public CronJobSchedule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CronJobSchedule.Builder {
    private String type;
    private String cronExpression;
    private Optional<String> timezone = Optional.empty();
    Builder() {
    }
    private Builder(CronJobSchedule source) {
      this.type = source.type();
      this.cronExpression = source.cronExpression();
      this.timezone = source.timezone();
    }
    @Override
    public CronJobSchedule.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public CronJobSchedule.Builder cronExpression(String cronExpression) {
      if (cronExpression == null) {
        throw new NullPointerException("Null cronExpression");
      }
      this.cronExpression = cronExpression;
      return this;
    }
    @Override
    public CronJobSchedule.Builder timezone(@Nullable String timezone) {
      this.timezone = Optional.ofNullable(timezone);
      return this;
    }
    @Override
    CronJobSchedule autoBuild() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.cronExpression == null) {
        missing += " cronExpression";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CronJobSchedule(
          this.type,
          this.cronExpression,
          this.timezone);
    }
  }

}
