package org.graylog.security.authservice.backend;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.graylog.security.authservice.ldap.LDAPTransportSecurity;
import org.graylog2.security.encryption.EncryptedValue;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ADAuthServiceBackendConfig extends ADAuthServiceBackendConfig {

  private final String type;

  private final ImmutableList<ADAuthServiceBackendConfig.HostAndPort> servers;

  private final LDAPTransportSecurity transportSecurity;

  private final boolean verifyCertificates;

  private final String systemUserDn;

  private final EncryptedValue systemUserPassword;

  private final String userSearchBase;

  private final String userSearchPattern;

  private final String userNameAttribute;

  private final String userFullNameAttribute;

  private AutoValue_ADAuthServiceBackendConfig(
      String type,
      ImmutableList<ADAuthServiceBackendConfig.HostAndPort> servers,
      LDAPTransportSecurity transportSecurity,
      boolean verifyCertificates,
      String systemUserDn,
      EncryptedValue systemUserPassword,
      String userSearchBase,
      String userSearchPattern,
      String userNameAttribute,
      String userFullNameAttribute) {
    this.type = type;
    this.servers = servers;
    this.transportSecurity = transportSecurity;
    this.verifyCertificates = verifyCertificates;
    this.systemUserDn = systemUserDn;
    this.systemUserPassword = systemUserPassword;
    this.userSearchBase = userSearchBase;
    this.userSearchPattern = userSearchPattern;
    this.userNameAttribute = userNameAttribute;
    this.userFullNameAttribute = userFullNameAttribute;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("servers")
  @Override
  public ImmutableList<ADAuthServiceBackendConfig.HostAndPort> servers() {
    return servers;
  }

  @JsonProperty("transport_security")
  @Override
  public LDAPTransportSecurity transportSecurity() {
    return transportSecurity;
  }

  @JsonProperty("verify_certificates")
  @Override
  public boolean verifyCertificates() {
    return verifyCertificates;
  }

  @JsonProperty("system_user_dn")
  @Override
  public String systemUserDn() {
    return systemUserDn;
  }

  @JsonProperty("system_user_password")
  @Override
  public EncryptedValue systemUserPassword() {
    return systemUserPassword;
  }

  @JsonProperty("user_search_base")
  @Override
  public String userSearchBase() {
    return userSearchBase;
  }

  @JsonProperty("user_search_pattern")
  @Override
  public String userSearchPattern() {
    return userSearchPattern;
  }

  @JsonProperty("user_name_attribute")
  @Override
  public String userNameAttribute() {
    return userNameAttribute;
  }

  @JsonProperty("user_full_name_attribute")
  @Override
  public String userFullNameAttribute() {
    return userFullNameAttribute;
  }

  @Override
  public String toString() {
    return "ADAuthServiceBackendConfig{"
        + "type=" + type + ", "
        + "servers=" + servers + ", "
        + "transportSecurity=" + transportSecurity + ", "
        + "verifyCertificates=" + verifyCertificates + ", "
        + "systemUserDn=" + systemUserDn + ", "
        + "systemUserPassword=" + systemUserPassword + ", "
        + "userSearchBase=" + userSearchBase + ", "
        + "userSearchPattern=" + userSearchPattern + ", "
        + "userNameAttribute=" + userNameAttribute + ", "
        + "userFullNameAttribute=" + userFullNameAttribute
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ADAuthServiceBackendConfig) {
      ADAuthServiceBackendConfig that = (ADAuthServiceBackendConfig) o;
      return this.type.equals(that.type())
          && this.servers.equals(that.servers())
          && this.transportSecurity.equals(that.transportSecurity())
          && this.verifyCertificates == that.verifyCertificates()
          && this.systemUserDn.equals(that.systemUserDn())
          && this.systemUserPassword.equals(that.systemUserPassword())
          && this.userSearchBase.equals(that.userSearchBase())
          && this.userSearchPattern.equals(that.userSearchPattern())
          && this.userNameAttribute.equals(that.userNameAttribute())
          && this.userFullNameAttribute.equals(that.userFullNameAttribute());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= servers.hashCode();
    h$ *= 1000003;
    h$ ^= transportSecurity.hashCode();
    h$ *= 1000003;
    h$ ^= verifyCertificates ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= systemUserDn.hashCode();
    h$ *= 1000003;
    h$ ^= systemUserPassword.hashCode();
    h$ *= 1000003;
    h$ ^= userSearchBase.hashCode();
    h$ *= 1000003;
    h$ ^= userSearchPattern.hashCode();
    h$ *= 1000003;
    h$ ^= userNameAttribute.hashCode();
    h$ *= 1000003;
    h$ ^= userFullNameAttribute.hashCode();
    return h$;
  }

  @Override
  public ADAuthServiceBackendConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ADAuthServiceBackendConfig.Builder {
    private String type;
    private ImmutableList<ADAuthServiceBackendConfig.HostAndPort> servers;
    private LDAPTransportSecurity transportSecurity;
    private Boolean verifyCertificates;
    private String systemUserDn;
    private EncryptedValue systemUserPassword;
    private String userSearchBase;
    private String userSearchPattern;
    private String userNameAttribute;
    private String userFullNameAttribute;
    Builder() {
    }
    private Builder(ADAuthServiceBackendConfig source) {
      this.type = source.type();
      this.servers = source.servers();
      this.transportSecurity = source.transportSecurity();
      this.verifyCertificates = source.verifyCertificates();
      this.systemUserDn = source.systemUserDn();
      this.systemUserPassword = source.systemUserPassword();
      this.userSearchBase = source.userSearchBase();
      this.userSearchPattern = source.userSearchPattern();
      this.userNameAttribute = source.userNameAttribute();
      this.userFullNameAttribute = source.userFullNameAttribute();
    }
    @Override
    public ADAuthServiceBackendConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder servers(List<ADAuthServiceBackendConfig.HostAndPort> servers) {
      this.servers = ImmutableList.copyOf(servers);
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder transportSecurity(LDAPTransportSecurity transportSecurity) {
      if (transportSecurity == null) {
        throw new NullPointerException("Null transportSecurity");
      }
      this.transportSecurity = transportSecurity;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder verifyCertificates(boolean verifyCertificates) {
      this.verifyCertificates = verifyCertificates;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder systemUserDn(String systemUserDn) {
      if (systemUserDn == null) {
        throw new NullPointerException("Null systemUserDn");
      }
      this.systemUserDn = systemUserDn;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder systemUserPassword(EncryptedValue systemUserPassword) {
      if (systemUserPassword == null) {
        throw new NullPointerException("Null systemUserPassword");
      }
      this.systemUserPassword = systemUserPassword;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder userSearchBase(String userSearchBase) {
      if (userSearchBase == null) {
        throw new NullPointerException("Null userSearchBase");
      }
      this.userSearchBase = userSearchBase;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder userSearchPattern(String userSearchPattern) {
      if (userSearchPattern == null) {
        throw new NullPointerException("Null userSearchPattern");
      }
      this.userSearchPattern = userSearchPattern;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder userNameAttribute(String userNameAttribute) {
      if (userNameAttribute == null) {
        throw new NullPointerException("Null userNameAttribute");
      }
      this.userNameAttribute = userNameAttribute;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig.Builder userFullNameAttribute(String userFullNameAttribute) {
      if (userFullNameAttribute == null) {
        throw new NullPointerException("Null userFullNameAttribute");
      }
      this.userFullNameAttribute = userFullNameAttribute;
      return this;
    }
    @Override
    public ADAuthServiceBackendConfig build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.servers == null) {
        missing += " servers";
      }
      if (this.transportSecurity == null) {
        missing += " transportSecurity";
      }
      if (this.verifyCertificates == null) {
        missing += " verifyCertificates";
      }
      if (this.systemUserDn == null) {
        missing += " systemUserDn";
      }
      if (this.systemUserPassword == null) {
        missing += " systemUserPassword";
      }
      if (this.userSearchBase == null) {
        missing += " userSearchBase";
      }
      if (this.userSearchPattern == null) {
        missing += " userSearchPattern";
      }
      if (this.userNameAttribute == null) {
        missing += " userNameAttribute";
      }
      if (this.userFullNameAttribute == null) {
        missing += " userFullNameAttribute";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ADAuthServiceBackendConfig(
          this.type,
          this.servers,
          this.transportSecurity,
          this.verifyCertificates,
          this.systemUserDn,
          this.systemUserPassword,
          this.userSearchBase,
          this.userSearchPattern,
          this.userNameAttribute,
          this.userFullNameAttribute);
    }
  }

}
