package org.graylog.security.authservice.ldap;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LDAPUser extends LDAPUser {

  private final String base64UniqueId;

  private final boolean accountIsEnabled;

  private final String username;

  private final String fullName;

  private final String email;

  private final LDAPEntry entry;

  private AutoValue_LDAPUser(
      String base64UniqueId,
      boolean accountIsEnabled,
      String username,
      String fullName,
      String email,
      LDAPEntry entry) {
    this.base64UniqueId = base64UniqueId;
    this.accountIsEnabled = accountIsEnabled;
    this.username = username;
    this.fullName = fullName;
    this.email = email;
    this.entry = entry;
  }

  @Override
  public String base64UniqueId() {
    return base64UniqueId;
  }

  @Override
  public boolean accountIsEnabled() {
    return accountIsEnabled;
  }

  @Override
  public String username() {
    return username;
  }

  @Override
  public String fullName() {
    return fullName;
  }

  @Override
  public String email() {
    return email;
  }

  @Override
  public LDAPEntry entry() {
    return entry;
  }

  @Override
  public String toString() {
    return "LDAPUser{"
        + "base64UniqueId=" + base64UniqueId + ", "
        + "accountIsEnabled=" + accountIsEnabled + ", "
        + "username=" + username + ", "
        + "fullName=" + fullName + ", "
        + "email=" + email + ", "
        + "entry=" + entry
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LDAPUser) {
      LDAPUser that = (LDAPUser) o;
      return this.base64UniqueId.equals(that.base64UniqueId())
          && this.accountIsEnabled == that.accountIsEnabled()
          && this.username.equals(that.username())
          && this.fullName.equals(that.fullName())
          && this.email.equals(that.email())
          && this.entry.equals(that.entry());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= base64UniqueId.hashCode();
    h$ *= 1000003;
    h$ ^= accountIsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= username.hashCode();
    h$ *= 1000003;
    h$ ^= fullName.hashCode();
    h$ *= 1000003;
    h$ ^= email.hashCode();
    h$ *= 1000003;
    h$ ^= entry.hashCode();
    return h$;
  }

  static final class Builder extends LDAPUser.Builder {
    private String base64UniqueId;
    private Boolean accountIsEnabled;
    private String username;
    private String fullName;
    private String email;
    private LDAPEntry entry;
    Builder() {
    }
    @Override
    public LDAPUser.Builder base64UniqueId(String base64UniqueId) {
      if (base64UniqueId == null) {
        throw new NullPointerException("Null base64UniqueId");
      }
      this.base64UniqueId = base64UniqueId;
      return this;
    }
    @Override
    public LDAPUser.Builder accountIsEnabled(boolean accountIsEnabled) {
      this.accountIsEnabled = accountIsEnabled;
      return this;
    }
    @Override
    public LDAPUser.Builder username(String username) {
      if (username == null) {
        throw new NullPointerException("Null username");
      }
      this.username = username;
      return this;
    }
    @Override
    public LDAPUser.Builder fullName(String fullName) {
      if (fullName == null) {
        throw new NullPointerException("Null fullName");
      }
      this.fullName = fullName;
      return this;
    }
    @Override
    public LDAPUser.Builder email(String email) {
      if (email == null) {
        throw new NullPointerException("Null email");
      }
      this.email = email;
      return this;
    }
    @Override
    public LDAPUser.Builder entry(LDAPEntry entry) {
      if (entry == null) {
        throw new NullPointerException("Null entry");
      }
      this.entry = entry;
      return this;
    }
    @Override
    public LDAPUser build() {
      String missing = "";
      if (this.base64UniqueId == null) {
        missing += " base64UniqueId";
      }
      if (this.accountIsEnabled == null) {
        missing += " accountIsEnabled";
      }
      if (this.username == null) {
        missing += " username";
      }
      if (this.fullName == null) {
        missing += " fullName";
      }
      if (this.email == null) {
        missing += " email";
      }
      if (this.entry == null) {
        missing += " entry";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LDAPUser(
          this.base64UniqueId,
          this.accountIsEnabled,
          this.username,
          this.fullName,
          this.email,
          this.entry);
    }
  }

}
