package org.graylog.security.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.grn.GRN;
import org.graylog.security.Capability;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GrantsOverviewResource_GrantSummary extends GrantsOverviewResource.GrantSummary {

  private final String id;

  private final GRN grantee;

  private final String granteeTitle;

  private final Capability capability;

  private final GRN target;

  private final String targetTitle;

  private final String createdBy;

  private final ZonedDateTime createdAt;

  private final String updatedBy;

  private final ZonedDateTime updatedAt;

  private final Optional<ZonedDateTime> expiresAt;

  private AutoValue_GrantsOverviewResource_GrantSummary(
      String id,
      GRN grantee,
      String granteeTitle,
      Capability capability,
      GRN target,
      String targetTitle,
      String createdBy,
      ZonedDateTime createdAt,
      String updatedBy,
      ZonedDateTime updatedAt,
      Optional<ZonedDateTime> expiresAt) {
    this.id = id;
    this.grantee = grantee;
    this.granteeTitle = granteeTitle;
    this.capability = capability;
    this.target = target;
    this.targetTitle = targetTitle;
    this.createdBy = createdBy;
    this.createdAt = createdAt;
    this.updatedBy = updatedBy;
    this.updatedAt = updatedAt;
    this.expiresAt = expiresAt;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("grantee")
  @Override
  public GRN grantee() {
    return grantee;
  }

  @JsonProperty("grantee_title")
  @Override
  public String granteeTitle() {
    return granteeTitle;
  }

  @JsonProperty("capability")
  @Override
  public Capability capability() {
    return capability;
  }

  @JsonProperty("target")
  @Override
  public GRN target() {
    return target;
  }

  @JsonProperty("target_title")
  @Override
  public String targetTitle() {
    return targetTitle;
  }

  @JsonProperty("created_by")
  @Override
  public String createdBy() {
    return createdBy;
  }

  @JsonProperty("created_at")
  @Override
  public ZonedDateTime createdAt() {
    return createdAt;
  }

  @JsonProperty("updated_by")
  @Override
  public String updatedBy() {
    return updatedBy;
  }

  @JsonProperty("updated_at")
  @Override
  public ZonedDateTime updatedAt() {
    return updatedAt;
  }

  @JsonProperty("expires_at")
  @Override
  public Optional<ZonedDateTime> expiresAt() {
    return expiresAt;
  }

  @Override
  public String toString() {
    return "GrantSummary{"
        + "id=" + id + ", "
        + "grantee=" + grantee + ", "
        + "granteeTitle=" + granteeTitle + ", "
        + "capability=" + capability + ", "
        + "target=" + target + ", "
        + "targetTitle=" + targetTitle + ", "
        + "createdBy=" + createdBy + ", "
        + "createdAt=" + createdAt + ", "
        + "updatedBy=" + updatedBy + ", "
        + "updatedAt=" + updatedAt + ", "
        + "expiresAt=" + expiresAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GrantsOverviewResource.GrantSummary) {
      GrantsOverviewResource.GrantSummary that = (GrantsOverviewResource.GrantSummary) o;
      return this.id.equals(that.id())
          && this.grantee.equals(that.grantee())
          && this.granteeTitle.equals(that.granteeTitle())
          && this.capability.equals(that.capability())
          && this.target.equals(that.target())
          && this.targetTitle.equals(that.targetTitle())
          && this.createdBy.equals(that.createdBy())
          && this.createdAt.equals(that.createdAt())
          && this.updatedBy.equals(that.updatedBy())
          && this.updatedAt.equals(that.updatedAt())
          && this.expiresAt.equals(that.expiresAt());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= grantee.hashCode();
    h$ *= 1000003;
    h$ ^= granteeTitle.hashCode();
    h$ *= 1000003;
    h$ ^= capability.hashCode();
    h$ *= 1000003;
    h$ ^= target.hashCode();
    h$ *= 1000003;
    h$ ^= targetTitle.hashCode();
    h$ *= 1000003;
    h$ ^= createdBy.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= updatedBy.hashCode();
    h$ *= 1000003;
    h$ ^= updatedAt.hashCode();
    h$ *= 1000003;
    h$ ^= expiresAt.hashCode();
    return h$;
  }

  static final class Builder extends GrantsOverviewResource.GrantSummary.Builder {
    private String id;
    private GRN grantee;
    private String granteeTitle;
    private Capability capability;
    private GRN target;
    private String targetTitle;
    private String createdBy;
    private ZonedDateTime createdAt;
    private String updatedBy;
    private ZonedDateTime updatedAt;
    private Optional<ZonedDateTime> expiresAt = Optional.empty();
    Builder() {
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder grantee(GRN grantee) {
      if (grantee == null) {
        throw new NullPointerException("Null grantee");
      }
      this.grantee = grantee;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder granteeTitle(String granteeTitle) {
      if (granteeTitle == null) {
        throw new NullPointerException("Null granteeTitle");
      }
      this.granteeTitle = granteeTitle;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder capability(Capability capability) {
      if (capability == null) {
        throw new NullPointerException("Null capability");
      }
      this.capability = capability;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder target(GRN target) {
      if (target == null) {
        throw new NullPointerException("Null target");
      }
      this.target = target;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder targetTitle(String targetTitle) {
      if (targetTitle == null) {
        throw new NullPointerException("Null targetTitle");
      }
      this.targetTitle = targetTitle;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder createdBy(String createdBy) {
      if (createdBy == null) {
        throw new NullPointerException("Null createdBy");
      }
      this.createdBy = createdBy;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder createdAt(ZonedDateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder updatedBy(String updatedBy) {
      if (updatedBy == null) {
        throw new NullPointerException("Null updatedBy");
      }
      this.updatedBy = updatedBy;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder updatedAt(ZonedDateTime updatedAt) {
      if (updatedAt == null) {
        throw new NullPointerException("Null updatedAt");
      }
      this.updatedAt = updatedAt;
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary.Builder expiresAt(@Nullable ZonedDateTime expiresAt) {
      this.expiresAt = Optional.ofNullable(expiresAt);
      return this;
    }
    @Override
    public GrantsOverviewResource.GrantSummary build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.grantee == null) {
        missing += " grantee";
      }
      if (this.granteeTitle == null) {
        missing += " granteeTitle";
      }
      if (this.capability == null) {
        missing += " capability";
      }
      if (this.target == null) {
        missing += " target";
      }
      if (this.targetTitle == null) {
        missing += " targetTitle";
      }
      if (this.createdBy == null) {
        missing += " createdBy";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (this.updatedBy == null) {
        missing += " updatedBy";
      }
      if (this.updatedAt == null) {
        missing += " updatedAt";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GrantsOverviewResource_GrantSummary(
          this.id,
          this.grantee,
          this.granteeTitle,
          this.capability,
          this.target,
          this.targetTitle,
          this.createdBy,
          this.createdAt,
          this.updatedBy,
          this.updatedAt,
          this.expiresAt);
    }
  }

}
