package org.graylog.storage.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Cause extends Cause {

  private final String type;

  private final String reason;

  private final String indexUuid;

  private final String index;

  private AutoValue_Cause(
      String type,
      String reason,
      @Nullable String indexUuid,
      @Nullable String index) {
    this.type = type;
    this.reason = reason;
    this.indexUuid = indexUuid;
    this.index = index;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public String reason() {
    return reason;
  }

  @JsonProperty
  @Nullable
  @Override
  public String indexUuid() {
    return indexUuid;
  }

  @JsonProperty
  @Nullable
  @Override
  public String index() {
    return index;
  }

  @Override
  public String toString() {
    return "Cause{"
        + "type=" + type + ", "
        + "reason=" + reason + ", "
        + "indexUuid=" + indexUuid + ", "
        + "index=" + index
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Cause) {
      Cause that = (Cause) o;
      return this.type.equals(that.type())
          && this.reason.equals(that.reason())
          && (this.indexUuid == null ? that.indexUuid() == null : this.indexUuid.equals(that.indexUuid()))
          && (this.index == null ? that.index() == null : this.index.equals(that.index()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= reason.hashCode();
    h$ *= 1000003;
    h$ ^= (indexUuid == null) ? 0 : indexUuid.hashCode();
    h$ *= 1000003;
    h$ ^= (index == null) ? 0 : index.hashCode();
    return h$;
  }

  static final class Builder extends Cause.Builder {
    private String type;
    private String reason;
    private String indexUuid;
    private String index;
    Builder() {
    }
    @Override
    public Cause.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public Cause.Builder reason(String reason) {
      if (reason == null) {
        throw new NullPointerException("Null reason");
      }
      this.reason = reason;
      return this;
    }
    @Override
    public Cause.Builder indexUuid(String indexUuid) {
      this.indexUuid = indexUuid;
      return this;
    }
    @Override
    public Cause.Builder index(String index) {
      this.index = index;
      return this;
    }
    @Override
    public Cause build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.reason == null) {
        missing += " reason";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Cause(
          this.type,
          this.reason,
          this.indexUuid,
          this.index);
    }
  }

}
