package org.graylog.storage.errors;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FailedShard extends FailedShard {

  private final int shard;

  private final String index;

  private final String node;

  private final Cause reason;

  private AutoValue_FailedShard(
      int shard,
      String index,
      String node,
      Cause reason) {
    this.shard = shard;
    this.index = index;
    this.node = node;
    this.reason = reason;
  }

  @Override
  public int shard() {
    return shard;
  }

  @Override
  public String index() {
    return index;
  }

  @Override
  public String node() {
    return node;
  }

  @Override
  public Cause reason() {
    return reason;
  }

  @Override
  public String toString() {
    return "FailedShard{"
        + "shard=" + shard + ", "
        + "index=" + index + ", "
        + "node=" + node + ", "
        + "reason=" + reason
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FailedShard) {
      FailedShard that = (FailedShard) o;
      return this.shard == that.shard()
          && this.index.equals(that.index())
          && this.node.equals(that.node())
          && this.reason.equals(that.reason());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= shard;
    h$ *= 1000003;
    h$ ^= index.hashCode();
    h$ *= 1000003;
    h$ ^= node.hashCode();
    h$ *= 1000003;
    h$ ^= reason.hashCode();
    return h$;
  }

  static final class Builder extends FailedShard.Builder {
    private Integer shard;
    private String index;
    private String node;
    private Cause reason;
    Builder() {
    }
    @Override
    public FailedShard.Builder shard(int shard) {
      this.shard = shard;
      return this;
    }
    @Override
    public FailedShard.Builder index(String index) {
      if (index == null) {
        throw new NullPointerException("Null index");
      }
      this.index = index;
      return this;
    }
    @Override
    public FailedShard.Builder node(String node) {
      if (node == null) {
        throw new NullPointerException("Null node");
      }
      this.node = node;
      return this;
    }
    @Override
    public FailedShard.Builder reason(Cause reason) {
      if (reason == null) {
        throw new NullPointerException("Null reason");
      }
      this.reason = reason;
      return this;
    }
    @Override
    public FailedShard build() {
      String missing = "";
      if (this.shard == null) {
        missing += " shard";
      }
      if (this.index == null) {
        missing += " index";
      }
      if (this.node == null) {
        missing += " node";
      }
      if (this.reason == null) {
        missing += " reason";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FailedShard(
          this.shard,
          this.index,
          this.node,
          this.reason);
    }
  }

}
