package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ExposedConfiguration extends ExposedConfiguration {

  private final int inputBufferProcessors;

  private final int processBufferProcessors;

  private final int outputBufferProcessors;

  private final int outputBatchSize;

  private final String processorWaitStrategy;

  private final String inputBufferWaitStrategy;

  private final int inputBufferRingSize;

  private final int ringSize;

  private final Path binDir;

  private final Path dataDir;

  private final Path pluginDir;

  private final String nodeIdFile;

  private final boolean allowHighlighting;

  private final boolean allowLeadingWildcardSearches;

  private final long streamProcessingTimeout;

  private final int streamProcessingMaxFaults;

  private final long outputModuleTimeout;

  private final int staleLeaderTimeout;

  $AutoValue_ExposedConfiguration(
      int inputBufferProcessors,
      int processBufferProcessors,
      int outputBufferProcessors,
      int outputBatchSize,
      String processorWaitStrategy,
      String inputBufferWaitStrategy,
      int inputBufferRingSize,
      int ringSize,
      Path binDir,
      Path dataDir,
      Path pluginDir,
      String nodeIdFile,
      boolean allowHighlighting,
      boolean allowLeadingWildcardSearches,
      long streamProcessingTimeout,
      int streamProcessingMaxFaults,
      long outputModuleTimeout,
      int staleLeaderTimeout) {
    this.inputBufferProcessors = inputBufferProcessors;
    this.processBufferProcessors = processBufferProcessors;
    this.outputBufferProcessors = outputBufferProcessors;
    this.outputBatchSize = outputBatchSize;
    if (processorWaitStrategy == null) {
      throw new NullPointerException("Null processorWaitStrategy");
    }
    this.processorWaitStrategy = processorWaitStrategy;
    if (inputBufferWaitStrategy == null) {
      throw new NullPointerException("Null inputBufferWaitStrategy");
    }
    this.inputBufferWaitStrategy = inputBufferWaitStrategy;
    this.inputBufferRingSize = inputBufferRingSize;
    this.ringSize = ringSize;
    if (binDir == null) {
      throw new NullPointerException("Null binDir");
    }
    this.binDir = binDir;
    if (dataDir == null) {
      throw new NullPointerException("Null dataDir");
    }
    this.dataDir = dataDir;
    if (pluginDir == null) {
      throw new NullPointerException("Null pluginDir");
    }
    this.pluginDir = pluginDir;
    if (nodeIdFile == null) {
      throw new NullPointerException("Null nodeIdFile");
    }
    this.nodeIdFile = nodeIdFile;
    this.allowHighlighting = allowHighlighting;
    this.allowLeadingWildcardSearches = allowLeadingWildcardSearches;
    this.streamProcessingTimeout = streamProcessingTimeout;
    this.streamProcessingMaxFaults = streamProcessingMaxFaults;
    this.outputModuleTimeout = outputModuleTimeout;
    this.staleLeaderTimeout = staleLeaderTimeout;
  }

  @JsonProperty("inputbuffer_processors")
  @Override
  public int inputBufferProcessors() {
    return inputBufferProcessors;
  }

  @JsonProperty("processbuffer_processors")
  @Override
  public int processBufferProcessors() {
    return processBufferProcessors;
  }

  @JsonProperty("outputbuffer_processors")
  @Override
  public int outputBufferProcessors() {
    return outputBufferProcessors;
  }

  @JsonProperty("output_batch_size")
  @Override
  public int outputBatchSize() {
    return outputBatchSize;
  }

  @JsonProperty("processor_wait_strategy")
  @Override
  public String processorWaitStrategy() {
    return processorWaitStrategy;
  }

  @JsonProperty("inputbuffer_wait_strategy")
  @Override
  public String inputBufferWaitStrategy() {
    return inputBufferWaitStrategy;
  }

  @JsonProperty("inputbuffer_ring_size")
  @Override
  public int inputBufferRingSize() {
    return inputBufferRingSize;
  }

  @JsonProperty("ring_size")
  @Override
  public int ringSize() {
    return ringSize;
  }

  @JsonProperty("bin_dir")
  @Override
  public Path binDir() {
    return binDir;
  }

  @JsonProperty("data_dir")
  @Override
  public Path dataDir() {
    return dataDir;
  }

  @JsonProperty("plugin_dir")
  @Override
  public Path pluginDir() {
    return pluginDir;
  }

  @JsonProperty("node_id_file")
  @Override
  public String nodeIdFile() {
    return nodeIdFile;
  }

  @JsonProperty("allow_highlighting")
  @Override
  public boolean allowHighlighting() {
    return allowHighlighting;
  }

  @JsonProperty("allow_leading_wildcard_searches")
  @Override
  public boolean allowLeadingWildcardSearches() {
    return allowLeadingWildcardSearches;
  }

  @JsonProperty("stream_processing_timeout")
  @Override
  public long streamProcessingTimeout() {
    return streamProcessingTimeout;
  }

  @JsonProperty("stream_processing_max_faults")
  @Override
  public int streamProcessingMaxFaults() {
    return streamProcessingMaxFaults;
  }

  @JsonProperty("output_module_timeout")
  @Override
  public long outputModuleTimeout() {
    return outputModuleTimeout;
  }

  @JsonProperty("stale_leader_timeout")
  @Override
  public int staleLeaderTimeout() {
    return staleLeaderTimeout;
  }

  @Override
  public String toString() {
    return "ExposedConfiguration{"
        + "inputBufferProcessors=" + inputBufferProcessors + ", "
        + "processBufferProcessors=" + processBufferProcessors + ", "
        + "outputBufferProcessors=" + outputBufferProcessors + ", "
        + "outputBatchSize=" + outputBatchSize + ", "
        + "processorWaitStrategy=" + processorWaitStrategy + ", "
        + "inputBufferWaitStrategy=" + inputBufferWaitStrategy + ", "
        + "inputBufferRingSize=" + inputBufferRingSize + ", "
        + "ringSize=" + ringSize + ", "
        + "binDir=" + binDir + ", "
        + "dataDir=" + dataDir + ", "
        + "pluginDir=" + pluginDir + ", "
        + "nodeIdFile=" + nodeIdFile + ", "
        + "allowHighlighting=" + allowHighlighting + ", "
        + "allowLeadingWildcardSearches=" + allowLeadingWildcardSearches + ", "
        + "streamProcessingTimeout=" + streamProcessingTimeout + ", "
        + "streamProcessingMaxFaults=" + streamProcessingMaxFaults + ", "
        + "outputModuleTimeout=" + outputModuleTimeout + ", "
        + "staleLeaderTimeout=" + staleLeaderTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExposedConfiguration) {
      ExposedConfiguration that = (ExposedConfiguration) o;
      return this.inputBufferProcessors == that.inputBufferProcessors()
          && this.processBufferProcessors == that.processBufferProcessors()
          && this.outputBufferProcessors == that.outputBufferProcessors()
          && this.outputBatchSize == that.outputBatchSize()
          && this.processorWaitStrategy.equals(that.processorWaitStrategy())
          && this.inputBufferWaitStrategy.equals(that.inputBufferWaitStrategy())
          && this.inputBufferRingSize == that.inputBufferRingSize()
          && this.ringSize == that.ringSize()
          && this.binDir.equals(that.binDir())
          && this.dataDir.equals(that.dataDir())
          && this.pluginDir.equals(that.pluginDir())
          && this.nodeIdFile.equals(that.nodeIdFile())
          && this.allowHighlighting == that.allowHighlighting()
          && this.allowLeadingWildcardSearches == that.allowLeadingWildcardSearches()
          && this.streamProcessingTimeout == that.streamProcessingTimeout()
          && this.streamProcessingMaxFaults == that.streamProcessingMaxFaults()
          && this.outputModuleTimeout == that.outputModuleTimeout()
          && this.staleLeaderTimeout == that.staleLeaderTimeout();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= inputBufferProcessors;
    h$ *= 1000003;
    h$ ^= processBufferProcessors;
    h$ *= 1000003;
    h$ ^= outputBufferProcessors;
    h$ *= 1000003;
    h$ ^= outputBatchSize;
    h$ *= 1000003;
    h$ ^= processorWaitStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= inputBufferWaitStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= inputBufferRingSize;
    h$ *= 1000003;
    h$ ^= ringSize;
    h$ *= 1000003;
    h$ ^= binDir.hashCode();
    h$ *= 1000003;
    h$ ^= dataDir.hashCode();
    h$ *= 1000003;
    h$ ^= pluginDir.hashCode();
    h$ *= 1000003;
    h$ ^= nodeIdFile.hashCode();
    h$ *= 1000003;
    h$ ^= allowHighlighting ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= allowLeadingWildcardSearches ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((streamProcessingTimeout >>> 32) ^ streamProcessingTimeout);
    h$ *= 1000003;
    h$ ^= streamProcessingMaxFaults;
    h$ *= 1000003;
    h$ ^= (int) ((outputModuleTimeout >>> 32) ^ outputModuleTimeout);
    h$ *= 1000003;
    h$ ^= staleLeaderTimeout;
    return h$;
  }

}
