package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.nio.file.Path;

final class AutoValue_ExposedConfiguration extends $AutoValue_ExposedConfiguration {
  AutoValue_ExposedConfiguration(int inputBufferProcessors, int processBufferProcessors,
      int outputBufferProcessors, int outputBatchSize, String processorWaitStrategy,
      String inputBufferWaitStrategy, int inputBufferRingSize, int ringSize, Path binDir,
      Path dataDir, Path pluginDir, String nodeIdFile, boolean allowHighlighting,
      boolean allowLeadingWildcardSearches, long streamProcessingTimeout,
      int streamProcessingMaxFaults, long outputModuleTimeout, int staleLeaderTimeout) {
    super(inputBufferProcessors, processBufferProcessors, outputBufferProcessors, outputBatchSize, processorWaitStrategy, inputBufferWaitStrategy, inputBufferRingSize, ringSize, binDir, dataDir, pluginDir, nodeIdFile, allowHighlighting, allowLeadingWildcardSearches, streamProcessingTimeout, streamProcessingMaxFaults, outputModuleTimeout, staleLeaderTimeout);
  }

  @JsonIgnore
  public final int getInputBufferProcessors() {
    return inputBufferProcessors();
  }

  @JsonIgnore
  public final int getProcessBufferProcessors() {
    return processBufferProcessors();
  }

  @JsonIgnore
  public final int getOutputBufferProcessors() {
    return outputBufferProcessors();
  }

  @JsonIgnore
  public final int getOutputBatchSize() {
    return outputBatchSize();
  }

  @JsonIgnore
  public final String getProcessorWaitStrategy() {
    return processorWaitStrategy();
  }

  @JsonIgnore
  public final String getInputBufferWaitStrategy() {
    return inputBufferWaitStrategy();
  }

  @JsonIgnore
  public final int getInputBufferRingSize() {
    return inputBufferRingSize();
  }

  @JsonIgnore
  public final int getRingSize() {
    return ringSize();
  }

  @JsonIgnore
  public final Path getBinDir() {
    return binDir();
  }

  @JsonIgnore
  public final Path getDataDir() {
    return dataDir();
  }

  @JsonIgnore
  public final Path getPluginDir() {
    return pluginDir();
  }

  @JsonIgnore
  public final String getNodeIdFile() {
    return nodeIdFile();
  }

  @JsonIgnore
  public final boolean isAllowHighlighting() {
    return allowHighlighting();
  }

  @JsonIgnore
  public final boolean isAllowLeadingWildcardSearches() {
    return allowLeadingWildcardSearches();
  }

  @JsonIgnore
  public final long getStreamProcessingTimeout() {
    return streamProcessingTimeout();
  }

  @JsonIgnore
  public final int getStreamProcessingMaxFaults() {
    return streamProcessingMaxFaults();
  }

  @JsonIgnore
  public final long getOutputModuleTimeout() {
    return outputModuleTimeout();
  }

  @JsonIgnore
  public final int getStaleLeaderTimeout() {
    return staleLeaderTimeout();
  }
}
