package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexSetsDefaultConfiguration extends IndexSetsDefaultConfiguration {

  private final @NotBlank String indexAnalyzer;

  private final @Min(1L) int shards;

  private final @Min(0L) int replicas;

  private final @Min(1L) int indexOptimizationMaxNumSegments;

  private final boolean indexOptimizationDisabled;

  private final @Min(0L) long fieldTypeRefreshInterval;

  private final TimeUnit fieldTypeRefreshIntervalUnit;

  private final @NotBlank String rotationStrategyClass;

  private final @NotNull RotationStrategyConfig rotationStrategyConfig;

  private final @NotBlank String retentionStrategyClass;

  private final @NotNull RetentionStrategyConfig retentionStrategyConfig;

  private AutoValue_IndexSetsDefaultConfiguration(
      @NotBlank String indexAnalyzer,
      @Min(1L) int shards,
      @Min(0L) int replicas,
      @Min(1L) int indexOptimizationMaxNumSegments,
      boolean indexOptimizationDisabled,
      @Min(0L) long fieldTypeRefreshInterval,
      TimeUnit fieldTypeRefreshIntervalUnit,
      @NotBlank String rotationStrategyClass,
      @NotNull RotationStrategyConfig rotationStrategyConfig,
      @NotBlank String retentionStrategyClass,
      @NotNull RetentionStrategyConfig retentionStrategyConfig) {
    this.indexAnalyzer = indexAnalyzer;
    this.shards = shards;
    this.replicas = replicas;
    this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
    this.indexOptimizationDisabled = indexOptimizationDisabled;
    this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
    this.fieldTypeRefreshIntervalUnit = fieldTypeRefreshIntervalUnit;
    this.rotationStrategyClass = rotationStrategyClass;
    this.rotationStrategyConfig = rotationStrategyConfig;
    this.retentionStrategyClass = retentionStrategyClass;
    this.retentionStrategyConfig = retentionStrategyConfig;
  }

  @JsonProperty("index_analyzer")
  @Override
  public @NotBlank String indexAnalyzer() {
    return indexAnalyzer;
  }

  @JsonProperty("shards")
  @Override
  public @Min(1L) int shards() {
    return shards;
  }

  @JsonProperty("replicas")
  @Override
  public @Min(0L) int replicas() {
    return replicas;
  }

  @JsonProperty("index_optimization_max_num_segments")
  @Override
  public @Min(1L) int indexOptimizationMaxNumSegments() {
    return indexOptimizationMaxNumSegments;
  }

  @JsonProperty("index_optimization_disabled")
  @Override
  public boolean indexOptimizationDisabled() {
    return indexOptimizationDisabled;
  }

  @JsonProperty("field_type_refresh_interval")
  @Override
  public @Min(0L) long fieldTypeRefreshInterval() {
    return fieldTypeRefreshInterval;
  }

  @JsonProperty("field_type_refresh_interval_unit")
  @Override
  public TimeUnit fieldTypeRefreshIntervalUnit() {
    return fieldTypeRefreshIntervalUnit;
  }

  @JsonProperty("rotation_strategy_class")
  @Override
  public @NotBlank String rotationStrategyClass() {
    return rotationStrategyClass;
  }

  @JsonProperty("rotation_strategy_config")
  @Override
  public @NotNull RotationStrategyConfig rotationStrategyConfig() {
    return rotationStrategyConfig;
  }

  @JsonProperty("retention_strategy_class")
  @Override
  public @NotBlank String retentionStrategyClass() {
    return retentionStrategyClass;
  }

  @JsonProperty("retention_strategy_config")
  @Override
  public @NotNull RetentionStrategyConfig retentionStrategyConfig() {
    return retentionStrategyConfig;
  }

  @Override
  public String toString() {
    return "IndexSetsDefaultConfiguration{"
        + "indexAnalyzer=" + indexAnalyzer + ", "
        + "shards=" + shards + ", "
        + "replicas=" + replicas + ", "
        + "indexOptimizationMaxNumSegments=" + indexOptimizationMaxNumSegments + ", "
        + "indexOptimizationDisabled=" + indexOptimizationDisabled + ", "
        + "fieldTypeRefreshInterval=" + fieldTypeRefreshInterval + ", "
        + "fieldTypeRefreshIntervalUnit=" + fieldTypeRefreshIntervalUnit + ", "
        + "rotationStrategyClass=" + rotationStrategyClass + ", "
        + "rotationStrategyConfig=" + rotationStrategyConfig + ", "
        + "retentionStrategyClass=" + retentionStrategyClass + ", "
        + "retentionStrategyConfig=" + retentionStrategyConfig
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexSetsDefaultConfiguration) {
      IndexSetsDefaultConfiguration that = (IndexSetsDefaultConfiguration) o;
      return this.indexAnalyzer.equals(that.indexAnalyzer())
          && this.shards == that.shards()
          && this.replicas == that.replicas()
          && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments()
          && this.indexOptimizationDisabled == that.indexOptimizationDisabled()
          && this.fieldTypeRefreshInterval == that.fieldTypeRefreshInterval()
          && this.fieldTypeRefreshIntervalUnit.equals(that.fieldTypeRefreshIntervalUnit())
          && this.rotationStrategyClass.equals(that.rotationStrategyClass())
          && this.rotationStrategyConfig.equals(that.rotationStrategyConfig())
          && this.retentionStrategyClass.equals(that.retentionStrategyClass())
          && this.retentionStrategyConfig.equals(that.retentionStrategyConfig());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= indexAnalyzer.hashCode();
    h$ *= 1000003;
    h$ ^= shards;
    h$ *= 1000003;
    h$ ^= replicas;
    h$ *= 1000003;
    h$ ^= indexOptimizationMaxNumSegments;
    h$ *= 1000003;
    h$ ^= indexOptimizationDisabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((fieldTypeRefreshInterval >>> 32) ^ fieldTypeRefreshInterval);
    h$ *= 1000003;
    h$ ^= fieldTypeRefreshIntervalUnit.hashCode();
    h$ *= 1000003;
    h$ ^= rotationStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= rotationStrategyConfig.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategyConfig.hashCode();
    return h$;
  }

  @Override
  public IndexSetsDefaultConfiguration.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends IndexSetsDefaultConfiguration.Builder {
    private @NotBlank String indexAnalyzer;
    private Integer shards;
    private Integer replicas;
    private Integer indexOptimizationMaxNumSegments;
    private Boolean indexOptimizationDisabled;
    private Long fieldTypeRefreshInterval;
    private TimeUnit fieldTypeRefreshIntervalUnit;
    private @NotBlank String rotationStrategyClass;
    private @NotNull RotationStrategyConfig rotationStrategyConfig;
    private @NotBlank String retentionStrategyClass;
    private @NotNull RetentionStrategyConfig retentionStrategyConfig;
    Builder() {
    }
    private Builder(IndexSetsDefaultConfiguration source) {
      this.indexAnalyzer = source.indexAnalyzer();
      this.shards = source.shards();
      this.replicas = source.replicas();
      this.indexOptimizationMaxNumSegments = source.indexOptimizationMaxNumSegments();
      this.indexOptimizationDisabled = source.indexOptimizationDisabled();
      this.fieldTypeRefreshInterval = source.fieldTypeRefreshInterval();
      this.fieldTypeRefreshIntervalUnit = source.fieldTypeRefreshIntervalUnit();
      this.rotationStrategyClass = source.rotationStrategyClass();
      this.rotationStrategyConfig = source.rotationStrategyConfig();
      this.retentionStrategyClass = source.retentionStrategyClass();
      this.retentionStrategyConfig = source.retentionStrategyConfig();
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder indexAnalyzer(String indexAnalyzer) {
      if (indexAnalyzer == null) {
        throw new NullPointerException("Null indexAnalyzer");
      }
      this.indexAnalyzer = indexAnalyzer;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder shards(int shards) {
      this.shards = shards;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder replicas(int replicas) {
      this.replicas = replicas;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder indexOptimizationMaxNumSegments(int indexOptimizationMaxNumSegments) {
      this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder indexOptimizationDisabled(boolean indexOptimizationDisabled) {
      this.indexOptimizationDisabled = indexOptimizationDisabled;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder fieldTypeRefreshInterval(long fieldTypeRefreshInterval) {
      this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder fieldTypeRefreshIntervalUnit(TimeUnit fieldTypeRefreshIntervalUnit) {
      if (fieldTypeRefreshIntervalUnit == null) {
        throw new NullPointerException("Null fieldTypeRefreshIntervalUnit");
      }
      this.fieldTypeRefreshIntervalUnit = fieldTypeRefreshIntervalUnit;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder rotationStrategyClass(String rotationStrategyClass) {
      if (rotationStrategyClass == null) {
        throw new NullPointerException("Null rotationStrategyClass");
      }
      this.rotationStrategyClass = rotationStrategyClass;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder rotationStrategyConfig(RotationStrategyConfig rotationStrategyConfig) {
      if (rotationStrategyConfig == null) {
        throw new NullPointerException("Null rotationStrategyConfig");
      }
      this.rotationStrategyConfig = rotationStrategyConfig;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder retentionStrategyClass(String retentionStrategyClass) {
      if (retentionStrategyClass == null) {
        throw new NullPointerException("Null retentionStrategyClass");
      }
      this.retentionStrategyClass = retentionStrategyClass;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration.Builder retentionStrategyConfig(RetentionStrategyConfig retentionStrategyConfig) {
      if (retentionStrategyConfig == null) {
        throw new NullPointerException("Null retentionStrategyConfig");
      }
      this.retentionStrategyConfig = retentionStrategyConfig;
      return this;
    }
    @Override
    public IndexSetsDefaultConfiguration build() {
      String missing = "";
      if (this.indexAnalyzer == null) {
        missing += " indexAnalyzer";
      }
      if (this.shards == null) {
        missing += " shards";
      }
      if (this.replicas == null) {
        missing += " replicas";
      }
      if (this.indexOptimizationMaxNumSegments == null) {
        missing += " indexOptimizationMaxNumSegments";
      }
      if (this.indexOptimizationDisabled == null) {
        missing += " indexOptimizationDisabled";
      }
      if (this.fieldTypeRefreshInterval == null) {
        missing += " fieldTypeRefreshInterval";
      }
      if (this.fieldTypeRefreshIntervalUnit == null) {
        missing += " fieldTypeRefreshIntervalUnit";
      }
      if (this.rotationStrategyClass == null) {
        missing += " rotationStrategyClass";
      }
      if (this.rotationStrategyConfig == null) {
        missing += " rotationStrategyConfig";
      }
      if (this.retentionStrategyClass == null) {
        missing += " retentionStrategyClass";
      }
      if (this.retentionStrategyConfig == null) {
        missing += " retentionStrategyConfig";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexSetsDefaultConfiguration(
          this.indexAnalyzer,
          this.shards,
          this.replicas,
          this.indexOptimizationMaxNumSegments,
          this.indexOptimizationDisabled,
          this.fieldTypeRefreshInterval,
          this.fieldTypeRefreshIntervalUnit,
          this.rotationStrategyClass,
          this.rotationStrategyConfig,
          this.retentionStrategyClass,
          this.retentionStrategyConfig);
    }
  }

}
