package org.graylog2.contentpacks.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.bson.types.ObjectId;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ContentPackInstallation extends ContentPackInstallation {

  private final ObjectId id;

  private final ModelId contentPackId;

  private final int contentPackRevision;

  private final ImmutableMap<String, ValueReference> parameters;

  private final ImmutableSet<NativeEntityDescriptor> entities;

  private final String comment;

  private final Instant createdAt;

  private final String createdBy;

  private AutoValue_ContentPackInstallation(
      @Nullable ObjectId id,
      ModelId contentPackId,
      int contentPackRevision,
      ImmutableMap<String, ValueReference> parameters,
      ImmutableSet<NativeEntityDescriptor> entities,
      String comment,
      Instant createdAt,
      String createdBy) {
    this.id = id;
    this.contentPackId = contentPackId;
    this.contentPackRevision = contentPackRevision;
    this.parameters = parameters;
    this.entities = entities;
    this.comment = comment;
    this.createdAt = createdAt;
    this.createdBy = createdBy;
  }

  @JsonProperty("_id")
  @Nullable
  @Override
  public ObjectId id() {
    return id;
  }

  @JsonProperty("content_pack_id")
  @Override
  public ModelId contentPackId() {
    return contentPackId;
  }

  @JsonProperty("content_pack_revision")
  @Override
  public int contentPackRevision() {
    return contentPackRevision;
  }

  @JsonProperty("parameters")
  @Override
  public ImmutableMap<String, ValueReference> parameters() {
    return parameters;
  }

  @JsonProperty("entities")
  @Override
  public ImmutableSet<NativeEntityDescriptor> entities() {
    return entities;
  }

  @JsonProperty("comment")
  @Override
  public String comment() {
    return comment;
  }

  @JsonProperty("created_at")
  @Override
  public Instant createdAt() {
    return createdAt;
  }

  @JsonProperty("created_by")
  @Override
  public String createdBy() {
    return createdBy;
  }

  @Override
  public String toString() {
    return "ContentPackInstallation{"
        + "id=" + id + ", "
        + "contentPackId=" + contentPackId + ", "
        + "contentPackRevision=" + contentPackRevision + ", "
        + "parameters=" + parameters + ", "
        + "entities=" + entities + ", "
        + "comment=" + comment + ", "
        + "createdAt=" + createdAt + ", "
        + "createdBy=" + createdBy
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ContentPackInstallation) {
      ContentPackInstallation that = (ContentPackInstallation) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.contentPackId.equals(that.contentPackId())
          && this.contentPackRevision == that.contentPackRevision()
          && this.parameters.equals(that.parameters())
          && this.entities.equals(that.entities())
          && this.comment.equals(that.comment())
          && this.createdAt.equals(that.createdAt())
          && this.createdBy.equals(that.createdBy());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= contentPackId.hashCode();
    h$ *= 1000003;
    h$ ^= contentPackRevision;
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= entities.hashCode();
    h$ *= 1000003;
    h$ ^= comment.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= createdBy.hashCode();
    return h$;
  }

  static final class Builder extends ContentPackInstallation.Builder {
    private ObjectId id;
    private ModelId contentPackId;
    private Integer contentPackRevision;
    private ImmutableMap<String, ValueReference> parameters;
    private ImmutableSet<NativeEntityDescriptor> entities;
    private String comment;
    private Instant createdAt;
    private String createdBy;
    Builder() {
    }
    @Override
    ContentPackInstallation.Builder id(ObjectId id) {
      this.id = id;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder contentPackId(ModelId contentPackId) {
      if (contentPackId == null) {
        throw new NullPointerException("Null contentPackId");
      }
      this.contentPackId = contentPackId;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder contentPackRevision(int contentPackRevision) {
      this.contentPackRevision = contentPackRevision;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder parameters(ImmutableMap<String, ValueReference> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder entities(ImmutableSet<NativeEntityDescriptor> entities) {
      if (entities == null) {
        throw new NullPointerException("Null entities");
      }
      this.entities = entities;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder comment(String comment) {
      if (comment == null) {
        throw new NullPointerException("Null comment");
      }
      this.comment = comment;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder createdAt(Instant createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public ContentPackInstallation.Builder createdBy(String createdBy) {
      if (createdBy == null) {
        throw new NullPointerException("Null createdBy");
      }
      this.createdBy = createdBy;
      return this;
    }
    @Override
    ContentPackInstallation autoBuild() {
      String missing = "";
      if (this.contentPackId == null) {
        missing += " contentPackId";
      }
      if (this.contentPackRevision == null) {
        missing += " contentPackRevision";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.entities == null) {
        missing += " entities";
      }
      if (this.comment == null) {
        missing += " comment";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (this.createdBy == null) {
        missing += " createdBy";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ContentPackInstallation(
          this.id,
          this.contentPackId,
          this.contentPackRevision,
          this.parameters,
          this.entities,
          this.comment,
          this.createdAt,
          this.createdBy);
    }
  }

}
