package org.graylog2.contentpacks.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import javax.annotation.processing.Generated;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ContentPackUninstallation extends ContentPackUninstallation {

  private final ImmutableSet<NativeEntityDescriptor> entities;

  private final ImmutableSet<NativeEntityDescriptor> failedEntities;

  private final ImmutableSet<NativeEntityDescriptor> skippedEntities;

  private AutoValue_ContentPackUninstallation(
      ImmutableSet<NativeEntityDescriptor> entities,
      ImmutableSet<NativeEntityDescriptor> failedEntities,
      ImmutableSet<NativeEntityDescriptor> skippedEntities) {
    this.entities = entities;
    this.failedEntities = failedEntities;
    this.skippedEntities = skippedEntities;
  }

  @JsonProperty("entities")
  @Override
  public ImmutableSet<NativeEntityDescriptor> entities() {
    return entities;
  }

  @JsonProperty("failed_entities")
  @Override
  public ImmutableSet<NativeEntityDescriptor> failedEntities() {
    return failedEntities;
  }

  @JsonProperty("skipped_entities")
  @Override
  public ImmutableSet<NativeEntityDescriptor> skippedEntities() {
    return skippedEntities;
  }

  @Override
  public String toString() {
    return "ContentPackUninstallation{"
        + "entities=" + entities + ", "
        + "failedEntities=" + failedEntities + ", "
        + "skippedEntities=" + skippedEntities
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ContentPackUninstallation) {
      ContentPackUninstallation that = (ContentPackUninstallation) o;
      return this.entities.equals(that.entities())
          && this.failedEntities.equals(that.failedEntities())
          && this.skippedEntities.equals(that.skippedEntities());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= entities.hashCode();
    h$ *= 1000003;
    h$ ^= failedEntities.hashCode();
    h$ *= 1000003;
    h$ ^= skippedEntities.hashCode();
    return h$;
  }

  @Override
  public ContentPackUninstallation.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ContentPackUninstallation.Builder {
    private ImmutableSet<NativeEntityDescriptor> entities;
    private ImmutableSet<NativeEntityDescriptor> failedEntities;
    private ImmutableSet<NativeEntityDescriptor> skippedEntities;
    Builder() {
    }
    private Builder(ContentPackUninstallation source) {
      this.entities = source.entities();
      this.failedEntities = source.failedEntities();
      this.skippedEntities = source.skippedEntities();
    }
    @Override
    public ContentPackUninstallation.Builder entities(ImmutableSet<NativeEntityDescriptor> entities) {
      if (entities == null) {
        throw new NullPointerException("Null entities");
      }
      this.entities = entities;
      return this;
    }
    @Override
    public ContentPackUninstallation.Builder failedEntities(ImmutableSet<NativeEntityDescriptor> failedEntities) {
      if (failedEntities == null) {
        throw new NullPointerException("Null failedEntities");
      }
      this.failedEntities = failedEntities;
      return this;
    }
    @Override
    public ContentPackUninstallation.Builder skippedEntities(ImmutableSet<NativeEntityDescriptor> skippedEntities) {
      if (skippedEntities == null) {
        throw new NullPointerException("Null skippedEntities");
      }
      this.skippedEntities = skippedEntities;
      return this;
    }
    @Override
    public ContentPackUninstallation build() {
      String missing = "";
      if (this.entities == null) {
        missing += " entities";
      }
      if (this.failedEntities == null) {
        missing += " failedEntities";
      }
      if (this.skippedEntities == null) {
        missing += " skippedEntities";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ContentPackUninstallation(
          this.entities,
          this.failedEntities,
          this.skippedEntities);
    }
  }

}
