package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_DashboardEntity extends $AutoValue_DashboardEntity {
  AutoValue_DashboardEntity(ValueReference title, ValueReference description,
      List<DashboardWidgetEntity> widgets) {
    super(title, description, widgets);
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  public final ValueReference getDescription() {
    return description();
  }

  @JsonIgnore
  @NotNull
  public final List<DashboardWidgetEntity> getWidgets() {
    return widgets();
  }
}
