package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_ExtractorEntity extends $AutoValue_ExtractorEntity {
  AutoValue_ExtractorEntity(ValueReference title, ValueReference type,
      ValueReference cursorStrategy, ValueReference targetField, ValueReference sourceField,
      ReferenceMap configuration, List<ConverterEntity> converters, ValueReference conditionType,
      ValueReference conditionValue, ValueReference order) {
    super(title, type, cursorStrategy, targetField, sourceField, configuration, converters, conditionType, conditionValue, order);
  }

  @JsonIgnore
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  public final ValueReference getType() {
    return type();
  }

  @JsonIgnore
  public final ValueReference getCursorStrategy() {
    return cursorStrategy();
  }

  @JsonIgnore
  public final ValueReference getTargetField() {
    return targetField();
  }

  @JsonIgnore
  public final ValueReference getSourceField() {
    return sourceField();
  }

  @JsonIgnore
  public final ReferenceMap getConfiguration() {
    return configuration();
  }

  @JsonIgnore
  public final List<ConverterEntity> getConverters() {
    return converters();
  }

  @JsonIgnore
  public final ValueReference getConditionType() {
    return conditionType();
  }

  @JsonIgnore
  public final ValueReference getConditionValue() {
    return conditionValue();
  }

  @JsonIgnore
  public final ValueReference getOrder() {
    return order();
  }
}
