package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.Nullable;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_SidecarCollectorEntity extends $AutoValue_SidecarCollectorEntity {
  AutoValue_SidecarCollectorEntity(ValueReference name, ValueReference serviceType,
      ValueReference nodeOperatingSystem, ValueReference executablePath,
      ValueReference executeParameters, ValueReference validationParameters,
      ValueReference defaultTemplate) {
    super(name, serviceType, nodeOperatingSystem, executablePath, executeParameters, validationParameters, defaultTemplate);
  }

  @JsonIgnore
  public final ValueReference getName() {
    return name();
  }

  @JsonIgnore
  public final ValueReference getServiceType() {
    return serviceType();
  }

  @JsonIgnore
  public final ValueReference getNodeOperatingSystem() {
    return nodeOperatingSystem();
  }

  @JsonIgnore
  public final ValueReference getExecutablePath() {
    return executablePath();
  }

  @JsonIgnore
  @Nullable
  public final ValueReference getExecuteParameters() {
    return executeParameters();
  }

  @JsonIgnore
  @Nullable
  public final ValueReference getValidationParameters() {
    return validationParameters();
  }

  @JsonIgnore
  public final ValueReference getDefaultTemplate() {
    return defaultTemplate();
  }
}
