package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_StreamRuleEntity extends $AutoValue_StreamRuleEntity {
  AutoValue_StreamRuleEntity(ValueReference type, ValueReference field, ValueReference value,
      ValueReference inverted, ValueReference description) {
    super(type, field, value, inverted, description);
  }

  @JsonIgnore
  @NotNull
  public final ValueReference getType() {
    return type();
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getField() {
    return field();
  }

  @JsonIgnore
  @NotNull
  public final ValueReference getValue() {
    return value();
  }

  @JsonIgnore
  public final ValueReference getInverted() {
    return inverted();
  }

  @JsonIgnore
  public final ValueReference getDescription() {
    return description();
  }
}
