package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.DisplayModeSettings;
import org.graylog.plugins.views.search.views.FormattingSettings;
import org.graylog.plugins.views.search.views.Titles;
import org.graylog.plugins.views.search.views.WidgetPositionDTO;

final class AutoValue_ViewStateEntity extends $AutoValue_ViewStateEntity {
  AutoValue_ViewStateEntity(Optional<Set<String>> fields, Optional<String> staticMessageListId,
      Titles titles, Set<WidgetEntity> widgets, Map<String, Set<String>> widgetMapping,
      Map<String, WidgetPositionDTO> widgetPositions, FormattingSettings formatting,
      DisplayModeSettings displayModeSettings) {
    super(fields, staticMessageListId, titles, widgets, widgetMapping, widgetPositions, formatting, displayModeSettings);
  }

  @JsonIgnore
  @Nullable
  public final Optional<Set<String>> getFields() {
    return fields();
  }

  @JsonIgnore
  @Nullable
  public final Optional<String> getStaticMessageListId() {
    return staticMessageListId();
  }

  @JsonIgnore
  public final Titles getTitles() {
    return titles();
  }

  @JsonIgnore
  public final Set<WidgetEntity> getWidgets() {
    return widgets();
  }

  @JsonIgnore
  public final Map<String, Set<String>> getWidgetMapping() {
    return widgetMapping();
  }

  @JsonIgnore
  public final Map<String, WidgetPositionDTO> getWidgetPositions() {
    return widgetPositions();
  }

  @JsonIgnore
  @Nullable
  public final FormattingSettings getFormatting() {
    return formatting();
  }

  @JsonIgnore
  public final DisplayModeSettings getDisplayModeSettings() {
    return displayModeSettings();
  }
}
