/*
 * Copyright (C) 2020 Graylog, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the Server Side Public License, version 1,
 * as published by MongoDB, Inc.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * Server Side Public License for more details.
 *
 * You should have received a copy of the Server Side Public License
 * along with this program. If not, see
 * <http://www.mongodb.com/licensing/server-side-public-license>.
 */
package org.graylog2.database.entities;

import java.util.Objects;

public abstract class EntityScope {

    public abstract String getName();

    public abstract boolean isMutable();

    public abstract boolean isDeletable();

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.getName());
        hash = 79 * hash + (isMutable() ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (getClass() != object.getClass()) {
            return false;
        }
        final DefaultEntityScope other = (DefaultEntityScope) object;
        if (this.isMutable() != other.isMutable()) {
            return false;
        }
        if (this.isDeletable() != other.isDeletable()) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }
}
