package org.graylog2.indexer.fieldtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexFieldTypesDTO extends IndexFieldTypesDTO {

  private final String id;

  private final String indexSetId;

  private final String indexName;

  private final ImmutableSet<FieldTypeDTO> fields;

  private final boolean hasStreamData;

  private AutoValue_IndexFieldTypesDTO(
      @Nullable String id,
      String indexSetId,
      String indexName,
      ImmutableSet<FieldTypeDTO> fields,
      boolean hasStreamData) {
    this.id = id;
    this.indexSetId = indexSetId;
    this.indexName = indexName;
    this.fields = fields;
    this.hasStreamData = hasStreamData;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("index_set_id")
  @Override
  public String indexSetId() {
    return indexSetId;
  }

  @JsonProperty("index_name")
  @Override
  public String indexName() {
    return indexName;
  }

  @JsonProperty("fields")
  @Override
  public ImmutableSet<FieldTypeDTO> fields() {
    return fields;
  }

  @JsonProperty("has_stream_data")
  @Override
  public boolean hasStreamData() {
    return hasStreamData;
  }

  @Override
  public String toString() {
    return "IndexFieldTypesDTO{"
        + "id=" + id + ", "
        + "indexSetId=" + indexSetId + ", "
        + "indexName=" + indexName + ", "
        + "fields=" + fields + ", "
        + "hasStreamData=" + hasStreamData
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexFieldTypesDTO) {
      IndexFieldTypesDTO that = (IndexFieldTypesDTO) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.indexSetId.equals(that.indexSetId())
          && this.indexName.equals(that.indexName())
          && this.fields.equals(that.fields())
          && this.hasStreamData == that.hasStreamData();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= indexSetId.hashCode();
    h$ *= 1000003;
    h$ ^= indexName.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= hasStreamData ? 1231 : 1237;
    return h$;
  }

  @Override
  public IndexFieldTypesDTO.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends IndexFieldTypesDTO.Builder {
    private String id;
    private String indexSetId;
    private String indexName;
    private ImmutableSet.Builder<FieldTypeDTO> fieldsBuilder$;
    private ImmutableSet<FieldTypeDTO> fields;
    private Boolean hasStreamData;
    Builder() {
    }
    private Builder(IndexFieldTypesDTO source) {
      this.id = source.id();
      this.indexSetId = source.indexSetId();
      this.indexName = source.indexName();
      this.fields = source.fields();
      this.hasStreamData = source.hasStreamData();
    }
    @Override
    public IndexFieldTypesDTO.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public IndexFieldTypesDTO.Builder indexSetId(String indexSetId) {
      if (indexSetId == null) {
        throw new NullPointerException("Null indexSetId");
      }
      this.indexSetId = indexSetId;
      return this;
    }
    @Override
    public IndexFieldTypesDTO.Builder indexName(String indexName) {
      if (indexName == null) {
        throw new NullPointerException("Null indexName");
      }
      this.indexName = indexName;
      return this;
    }
    @Override
    ImmutableSet.Builder<FieldTypeDTO> fieldsBuilder() {
      if (fieldsBuilder$ == null) {
        if (fields == null) {
          fieldsBuilder$ = ImmutableSet.builder();
        } else {
          fieldsBuilder$ = ImmutableSet.builder();
          fieldsBuilder$.addAll(fields);
          fields = null;
        }
      }
      return fieldsBuilder$;
    }
    @Override
    public IndexFieldTypesDTO.Builder hasStreamData(boolean hasStreamData) {
      this.hasStreamData = hasStreamData;
      return this;
    }
    @Override
    public IndexFieldTypesDTO build() {
      if (fieldsBuilder$ != null) {
        this.fields = fieldsBuilder$.build();
      } else if (this.fields == null) {
        this.fields = ImmutableSet.of();
      }
      String missing = "";
      if (this.indexSetId == null) {
        missing += " indexSetId";
      }
      if (this.indexName == null) {
        missing += " indexName";
      }
      if (this.hasStreamData == null) {
        missing += " hasStreamData";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexFieldTypesDTO(
          this.id,
          this.indexSetId,
          this.indexName,
          this.fields,
          this.hasStreamData);
    }
  }

}
