package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import java.lang.String;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.graylog2.lookup.adapters.dnslookup.DnsLookupType;

final class AutoValue_DnsLookupDataAdapter_Config extends $AutoValue_DnsLookupDataAdapter_Config {
  AutoValue_DnsLookupDataAdapter_Config(String type, DnsLookupType lookupType, String serverIps,
      int requestTimeout, boolean cacheTTLOverrideEnabled, Long cacheTTLOverride,
      TimeUnit cacheTTLOverrideUnit) {
    super(type, lookupType, serverIps, requestTimeout, cacheTTLOverrideEnabled, cacheTTLOverride, cacheTTLOverrideUnit);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  public final DnsLookupType getLookupType() {
    return lookupType();
  }

  @JsonIgnore
  public final String getServerIps() {
    return serverIps();
  }

  @JsonIgnore
  public final int getRequestTimeout() {
    return requestTimeout();
  }

  @JsonIgnore
  public final boolean isCacheTTLOverrideEnabled() {
    return cacheTTLOverrideEnabled();
  }

  @JsonIgnore
  @Nullable
  public final Long getCacheTTLOverride() {
    return cacheTTLOverride();
  }

  @JsonIgnore
  @Nullable
  public final TimeUnit getCacheTTLOverrideUnit() {
    return cacheTTLOverrideUnit();
  }
}
