package org.graylog2.lookup.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.lookup.LookupDefaultValue;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LookupTableDto extends LookupTableDto {

  private final String id;

  private final String scope;

  private final String title;

  private final String description;

  private final String name;

  private final String cacheId;

  private final String dataAdapterId;

  private final String contentPack;

  private final String defaultSingleValue;

  private final LookupDefaultValue.Type defaultSingleValueType;

  private final String defaultMultiValue;

  private final LookupDefaultValue.Type defaultMultiValueType;

  private AutoValue_LookupTableDto(
      @Nullable String id,
      String scope,
      String title,
      String description,
      String name,
      String cacheId,
      String dataAdapterId,
      @Nullable String contentPack,
      String defaultSingleValue,
      LookupDefaultValue.Type defaultSingleValueType,
      String defaultMultiValue,
      LookupDefaultValue.Type defaultMultiValueType) {
    this.id = id;
    this.scope = scope;
    this.title = title;
    this.description = description;
    this.name = name;
    this.cacheId = cacheId;
    this.dataAdapterId = dataAdapterId;
    this.contentPack = contentPack;
    this.defaultSingleValue = defaultSingleValue;
    this.defaultSingleValueType = defaultSingleValueType;
    this.defaultMultiValue = defaultMultiValue;
    this.defaultMultiValueType = defaultMultiValueType;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("_scope")
  @Override
  public String scope() {
    return scope;
  }

  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  @ObjectId
  @JsonProperty("cache")
  @Override
  public String cacheId() {
    return cacheId;
  }

  @ObjectId
  @JsonProperty("data_adapter")
  @Override
  public String dataAdapterId() {
    return dataAdapterId;
  }

  @JsonProperty("content_pack")
  @Nullable
  @Override
  public String contentPack() {
    return contentPack;
  }

  @JsonProperty("default_single_value")
  @Override
  public String defaultSingleValue() {
    return defaultSingleValue;
  }

  @JsonProperty("default_single_value_type")
  @Override
  public LookupDefaultValue.Type defaultSingleValueType() {
    return defaultSingleValueType;
  }

  @JsonProperty("default_multi_value")
  @Override
  public String defaultMultiValue() {
    return defaultMultiValue;
  }

  @JsonProperty("default_multi_value_type")
  @Override
  public LookupDefaultValue.Type defaultMultiValueType() {
    return defaultMultiValueType;
  }

  @Override
  public String toString() {
    return "LookupTableDto{"
        + "id=" + id + ", "
        + "scope=" + scope + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "name=" + name + ", "
        + "cacheId=" + cacheId + ", "
        + "dataAdapterId=" + dataAdapterId + ", "
        + "contentPack=" + contentPack + ", "
        + "defaultSingleValue=" + defaultSingleValue + ", "
        + "defaultSingleValueType=" + defaultSingleValueType + ", "
        + "defaultMultiValue=" + defaultMultiValue + ", "
        + "defaultMultiValueType=" + defaultMultiValueType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LookupTableDto) {
      LookupTableDto that = (LookupTableDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.scope.equals(that.scope())
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.name.equals(that.name())
          && this.cacheId.equals(that.cacheId())
          && this.dataAdapterId.equals(that.dataAdapterId())
          && (this.contentPack == null ? that.contentPack() == null : this.contentPack.equals(that.contentPack()))
          && this.defaultSingleValue.equals(that.defaultSingleValue())
          && this.defaultSingleValueType.equals(that.defaultSingleValueType())
          && this.defaultMultiValue.equals(that.defaultMultiValue())
          && this.defaultMultiValueType.equals(that.defaultMultiValueType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= cacheId.hashCode();
    h$ *= 1000003;
    h$ ^= dataAdapterId.hashCode();
    h$ *= 1000003;
    h$ ^= (contentPack == null) ? 0 : contentPack.hashCode();
    h$ *= 1000003;
    h$ ^= defaultSingleValue.hashCode();
    h$ *= 1000003;
    h$ ^= defaultSingleValueType.hashCode();
    h$ *= 1000003;
    h$ ^= defaultMultiValue.hashCode();
    h$ *= 1000003;
    h$ ^= defaultMultiValueType.hashCode();
    return h$;
  }

  static final class Builder extends LookupTableDto.Builder {
    private String id;
    private String scope;
    private String title;
    private String description;
    private String name;
    private String cacheId;
    private String dataAdapterId;
    private String contentPack;
    private String defaultSingleValue;
    private LookupDefaultValue.Type defaultSingleValueType;
    private String defaultMultiValue;
    private LookupDefaultValue.Type defaultMultiValueType;
    Builder() {
    }
    @Override
    public LookupTableDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public LookupTableDto.Builder scope(String scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    public LookupTableDto.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public LookupTableDto.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public LookupTableDto.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public LookupTableDto.Builder cacheId(String cacheId) {
      if (cacheId == null) {
        throw new NullPointerException("Null cacheId");
      }
      this.cacheId = cacheId;
      return this;
    }
    @Override
    public LookupTableDto.Builder dataAdapterId(String dataAdapterId) {
      if (dataAdapterId == null) {
        throw new NullPointerException("Null dataAdapterId");
      }
      this.dataAdapterId = dataAdapterId;
      return this;
    }
    @Override
    public LookupTableDto.Builder contentPack(@Nullable String contentPack) {
      this.contentPack = contentPack;
      return this;
    }
    @Override
    public LookupTableDto.Builder defaultSingleValue(String defaultSingleValue) {
      if (defaultSingleValue == null) {
        throw new NullPointerException("Null defaultSingleValue");
      }
      this.defaultSingleValue = defaultSingleValue;
      return this;
    }
    @Override
    public LookupTableDto.Builder defaultSingleValueType(LookupDefaultValue.Type defaultSingleValueType) {
      if (defaultSingleValueType == null) {
        throw new NullPointerException("Null defaultSingleValueType");
      }
      this.defaultSingleValueType = defaultSingleValueType;
      return this;
    }
    @Override
    public LookupTableDto.Builder defaultMultiValue(String defaultMultiValue) {
      if (defaultMultiValue == null) {
        throw new NullPointerException("Null defaultMultiValue");
      }
      this.defaultMultiValue = defaultMultiValue;
      return this;
    }
    @Override
    public LookupTableDto.Builder defaultMultiValueType(LookupDefaultValue.Type defaultMultiValueType) {
      if (defaultMultiValueType == null) {
        throw new NullPointerException("Null defaultMultiValueType");
      }
      this.defaultMultiValueType = defaultMultiValueType;
      return this;
    }
    @Override
    public LookupTableDto build() {
      String missing = "";
      if (this.scope == null) {
        missing += " scope";
      }
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.cacheId == null) {
        missing += " cacheId";
      }
      if (this.dataAdapterId == null) {
        missing += " dataAdapterId";
      }
      if (this.defaultSingleValue == null) {
        missing += " defaultSingleValue";
      }
      if (this.defaultSingleValueType == null) {
        missing += " defaultSingleValueType";
      }
      if (this.defaultMultiValue == null) {
        missing += " defaultMultiValue";
      }
      if (this.defaultMultiValueType == null) {
        missing += " defaultMultiValueType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LookupTableDto(
          this.id,
          this.scope,
          this.title,
          this.description,
          this.name,
          this.cacheId,
          this.dataAdapterId,
          this.contentPack,
          this.defaultSingleValue,
          this.defaultSingleValueType,
          this.defaultMultiValue,
          this.defaultMultiValueType);
    }
  }

}
