package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_KeywordRange extends KeywordRange {

  private final String keyword;

  private final String timezone;

  private AutoValue_KeywordRange(
      String keyword,
      String timezone) {
    this.keyword = keyword;
    this.timezone = timezone;
  }

  @JsonProperty
  @Override
  public String keyword() {
    return keyword;
  }

  @JsonProperty
  @Override
  public String timezone() {
    return timezone;
  }

  @Override
  public String toString() {
    return "KeywordRange{"
        + "keyword=" + keyword + ", "
        + "timezone=" + timezone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof KeywordRange) {
      KeywordRange that = (KeywordRange) o;
      return this.keyword.equals(that.keyword())
          && this.timezone.equals(that.timezone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= keyword.hashCode();
    h$ *= 1000003;
    h$ ^= timezone.hashCode();
    return h$;
  }

  static final class Builder extends KeywordRange.Builder {
    private String keyword;
    private String timezone;
    Builder() {
    }
    @Override
    public KeywordRange.Builder keyword(String keyword) {
      if (keyword == null) {
        throw new NullPointerException("Null keyword");
      }
      this.keyword = keyword;
      return this;
    }
    @Override
    String keyword() {
      if (keyword == null) {
        throw new IllegalStateException("Property \"keyword\" has not been set");
      }
      return keyword;
    }
    @Override
    public KeywordRange.Builder timezone(String timezone) {
      if (timezone == null) {
        throw new NullPointerException("Null timezone");
      }
      this.timezone = timezone;
      return this;
    }
    @Override
    String timezone() {
      if (timezone == null) {
        throw new IllegalStateException("Property \"timezone\" has not been set");
      }
      return timezone;
    }
    @Override
    KeywordRange autoBuild() {
      String missing = "";
      if (this.keyword == null) {
        missing += " keyword";
      }
      if (this.timezone == null) {
        missing += " timezone";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_KeywordRange(
          this.keyword,
          this.timezone);
    }
  }

}
