package org.graylog2.plugin.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LookupResult extends LookupResult {

  private final Object singleValue;

  private final Map<Object, Object> multiValue;

  private final List<String> stringListValue;

  private final boolean hasError;

  private final long cacheTTL;

  private AutoValue_LookupResult(
      @Nullable Object singleValue,
      @Nullable Map<Object, Object> multiValue,
      @Nullable List<String> stringListValue,
      boolean hasError,
      long cacheTTL) {
    this.singleValue = singleValue;
    this.multiValue = multiValue;
    this.stringListValue = stringListValue;
    this.hasError = hasError;
    this.cacheTTL = cacheTTL;
  }

  @JsonProperty("single_value")
  @Nullable
  @Override
  public Object singleValue() {
    return singleValue;
  }

  @JsonProperty("multi_value")
  @Nullable
  @Override
  public Map<Object, Object> multiValue() {
    return multiValue;
  }

  @JsonProperty("string_list_value")
  @Nullable
  @Override
  public List<String> stringListValue() {
    return stringListValue;
  }

  @JsonProperty("has_error")
  @Override
  public boolean hasError() {
    return hasError;
  }

  @JsonProperty("ttl")
  @Override
  public long cacheTTL() {
    return cacheTTL;
  }

  @Override
  public String toString() {
    return "LookupResult{"
        + "singleValue=" + singleValue + ", "
        + "multiValue=" + multiValue + ", "
        + "stringListValue=" + stringListValue + ", "
        + "hasError=" + hasError + ", "
        + "cacheTTL=" + cacheTTL
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LookupResult) {
      LookupResult that = (LookupResult) o;
      return (this.singleValue == null ? that.singleValue() == null : this.singleValue.equals(that.singleValue()))
          && (this.multiValue == null ? that.multiValue() == null : this.multiValue.equals(that.multiValue()))
          && (this.stringListValue == null ? that.stringListValue() == null : this.stringListValue.equals(that.stringListValue()))
          && this.hasError == that.hasError()
          && this.cacheTTL == that.cacheTTL();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (singleValue == null) ? 0 : singleValue.hashCode();
    h$ *= 1000003;
    h$ ^= (multiValue == null) ? 0 : multiValue.hashCode();
    h$ *= 1000003;
    h$ ^= (stringListValue == null) ? 0 : stringListValue.hashCode();
    h$ *= 1000003;
    h$ ^= hasError ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((cacheTTL >>> 32) ^ cacheTTL);
    return h$;
  }

  static final class Builder extends LookupResult.Builder {
    private Object singleValue;
    private Map<Object, Object> multiValue;
    private List<String> stringListValue;
    private Boolean hasError;
    private Long cacheTTL;
    Builder() {
    }
    @Override
    LookupResult.Builder singleValue(Object singleValue) {
      this.singleValue = singleValue;
      return this;
    }
    @Override
    public LookupResult.Builder multiValue(Map<Object, Object> multiValue) {
      this.multiValue = multiValue;
      return this;
    }
    @Override
    public LookupResult.Builder stringListValue(List<String> stringListValue) {
      this.stringListValue = stringListValue;
      return this;
    }
    @Override
    public LookupResult.Builder hasError(boolean hasError) {
      this.hasError = hasError;
      return this;
    }
    @Override
    public LookupResult.Builder cacheTTL(long cacheTTL) {
      this.cacheTTL = cacheTTL;
      return this;
    }
    @Override
    public LookupResult build() {
      String missing = "";
      if (this.hasError == null) {
        missing += " hasError";
      }
      if (this.cacheTTL == null) {
        missing += " cacheTTL";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LookupResult(
          this.singleValue,
          this.multiValue,
          this.stringListValue,
          this.hasError,
          this.cacheTTL);
    }
  }

}
