package org.graylog2.rest.models.system.inputs.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_InputCreateRequest extends InputCreateRequest {

  private final String title;

  private final String type;

  private final boolean global;

  private final Map<String, Object> configuration;

  private final String node;

  $AutoValue_InputCreateRequest(
      String title,
      String type,
      boolean global,
      Map<String, Object> configuration,
      @Nullable String node) {
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    this.global = global;
    if (configuration == null) {
      throw new NullPointerException("Null configuration");
    }
    this.configuration = configuration;
    this.node = node;
  }

  @JsonProperty
  @Override
  public String title() {
    return title;
  }

  @JsonProperty
  @Override
  public String type() {
    return type;
  }

  @JsonProperty
  @Override
  public boolean global() {
    return global;
  }

  @JsonProperty
  @Override
  public Map<String, Object> configuration() {
    return configuration;
  }

  @JsonProperty
  @Nullable
  @Override
  public String node() {
    return node;
  }

  @Override
  public String toString() {
    return "InputCreateRequest{"
        + "title=" + title + ", "
        + "type=" + type + ", "
        + "global=" + global + ", "
        + "configuration=" + configuration + ", "
        + "node=" + node
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InputCreateRequest) {
      InputCreateRequest that = (InputCreateRequest) o;
      return this.title.equals(that.title())
          && this.type.equals(that.type())
          && this.global == that.global()
          && this.configuration.equals(that.configuration())
          && (this.node == null ? that.node() == null : this.node.equals(that.node()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= global ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= configuration.hashCode();
    h$ *= 1000003;
    h$ ^= (node == null) ? 0 : node.hashCode();
    return h$;
  }

  @Override
  public InputCreateRequest.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends InputCreateRequest.Builder {
    private String title;
    private String type;
    private Boolean global;
    private Map<String, Object> configuration;
    private String node;
    Builder() {
    }
    private Builder(InputCreateRequest source) {
      this.title = source.title();
      this.type = source.type();
      this.global = source.global();
      this.configuration = source.configuration();
      this.node = source.node();
    }
    @Override
    public InputCreateRequest.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public InputCreateRequest.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public InputCreateRequest.Builder global(boolean global) {
      this.global = global;
      return this;
    }
    @Override
    public InputCreateRequest.Builder configuration(Map<String, Object> configuration) {
      if (configuration == null) {
        throw new NullPointerException("Null configuration");
      }
      this.configuration = configuration;
      return this;
    }
    @Override
    public InputCreateRequest.Builder node(String node) {
      this.node = node;
      return this;
    }
    @Override
    public InputCreateRequest build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.global == null) {
        missing += " global";
      }
      if (this.configuration == null) {
        missing += " configuration";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InputCreateRequest(
          this.title,
          this.type,
          this.global,
          this.configuration,
          this.node);
    }
  }

}
