package org.graylog2.rest.models.system.loggers.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_InternalLogMessage extends InternalLogMessage {

  private final @NotEmpty String message;

  private final String className;

  private final @NotEmpty String level;

  private final String marker;

  private final @NotNull DateTime timestamp;

  private final String throwable;

  private final @NotEmpty String threadName;

  private final @NotNull Map<String, String> context;

  $AutoValue_InternalLogMessage(
      @NotEmpty String message,
      @Nullable String className,
      @NotEmpty String level,
      @Nullable String marker,
      @NotNull DateTime timestamp,
      @Nullable String throwable,
      @NotEmpty String threadName,
      @NotNull Map<String, String> context) {
    if (message == null) {
      throw new NullPointerException("Null message");
    }
    this.message = message;
    this.className = className;
    if (level == null) {
      throw new NullPointerException("Null level");
    }
    this.level = level;
    this.marker = marker;
    if (timestamp == null) {
      throw new NullPointerException("Null timestamp");
    }
    this.timestamp = timestamp;
    this.throwable = throwable;
    if (threadName == null) {
      throw new NullPointerException("Null threadName");
    }
    this.threadName = threadName;
    if (context == null) {
      throw new NullPointerException("Null context");
    }
    this.context = context;
  }

  @JsonProperty
  @Override
  public @NotEmpty String message() {
    return message;
  }

  @JsonProperty("class_name")
  @Nullable
  @Override
  public String className() {
    return className;
  }

  @JsonProperty
  @Override
  public @NotEmpty String level() {
    return level;
  }

  @JsonProperty
  @Nullable
  @Override
  public String marker() {
    return marker;
  }

  @JsonProperty
  @Override
  public @NotNull DateTime timestamp() {
    return timestamp;
  }

  @JsonProperty
  @Nullable
  @Override
  public String throwable() {
    return throwable;
  }

  @JsonProperty("thread_name")
  @Override
  public @NotEmpty String threadName() {
    return threadName;
  }

  @JsonProperty
  @Override
  public @NotNull Map<String, String> context() {
    return context;
  }

  @Override
  public String toString() {
    return "InternalLogMessage{"
        + "message=" + message + ", "
        + "className=" + className + ", "
        + "level=" + level + ", "
        + "marker=" + marker + ", "
        + "timestamp=" + timestamp + ", "
        + "throwable=" + throwable + ", "
        + "threadName=" + threadName + ", "
        + "context=" + context
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InternalLogMessage) {
      InternalLogMessage that = (InternalLogMessage) o;
      return this.message.equals(that.message())
          && (this.className == null ? that.className() == null : this.className.equals(that.className()))
          && this.level.equals(that.level())
          && (this.marker == null ? that.marker() == null : this.marker.equals(that.marker()))
          && this.timestamp.equals(that.timestamp())
          && (this.throwable == null ? that.throwable() == null : this.throwable.equals(that.throwable()))
          && this.threadName.equals(that.threadName())
          && this.context.equals(that.context());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= message.hashCode();
    h$ *= 1000003;
    h$ ^= (className == null) ? 0 : className.hashCode();
    h$ *= 1000003;
    h$ ^= level.hashCode();
    h$ *= 1000003;
    h$ ^= (marker == null) ? 0 : marker.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= (throwable == null) ? 0 : throwable.hashCode();
    h$ *= 1000003;
    h$ ^= threadName.hashCode();
    h$ *= 1000003;
    h$ ^= context.hashCode();
    return h$;
  }

}
