package org.graylog2.rest.models.system.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_DataAdapterApi extends DataAdapterApi {

  private final String id;

  private final String scope;

  private final @NotEmpty String title;

  private final String description;

  private final @NotEmpty String name;

  private final Boolean customErrorTTLEnabled;

  private final Long customErrorTTL;

  private final TimeUnit customErrorTTLUnit;

  private final String contentPack;

  private final @NotNull LookupDataAdapterConfiguration config;

  $AutoValue_DataAdapterApi(
      @Nullable String id,
      @Nullable String scope,
      @NotEmpty String title,
      String description,
      @NotEmpty String name,
      @Nullable Boolean customErrorTTLEnabled,
      @Nullable Long customErrorTTL,
      @Nullable TimeUnit customErrorTTLUnit,
      @Nullable String contentPack,
      @NotNull LookupDataAdapterConfiguration config) {
    this.id = id;
    this.scope = scope;
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    if (description == null) {
      throw new NullPointerException("Null description");
    }
    this.description = description;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    this.customErrorTTLEnabled = customErrorTTLEnabled;
    this.customErrorTTL = customErrorTTL;
    this.customErrorTTLUnit = customErrorTTLUnit;
    this.contentPack = contentPack;
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
  }

  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @Nullable
  @JsonProperty("_scope")
  @Override
  public String scope() {
    return scope;
  }

  @JsonProperty("title")
  @Override
  public @NotEmpty String title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("name")
  @Override
  public @NotEmpty String name() {
    return name;
  }

  @Nullable
  @JsonProperty("custom_error_ttl_enabled")
  @Override
  public Boolean customErrorTTLEnabled() {
    return customErrorTTLEnabled;
  }

  @Nullable
  @JsonProperty("custom_error_ttl")
  @Override
  public Long customErrorTTL() {
    return customErrorTTL;
  }

  @Nullable
  @JsonProperty("custom_error_ttl_unit")
  @Override
  public TimeUnit customErrorTTLUnit() {
    return customErrorTTLUnit;
  }

  @JsonProperty("content_pack")
  @Nullable
  @Override
  public String contentPack() {
    return contentPack;
  }

  @JsonProperty("config")
  @Override
  public @NotNull LookupDataAdapterConfiguration config() {
    return config;
  }

  @Override
  public String toString() {
    return "DataAdapterApi{"
        + "id=" + id + ", "
        + "scope=" + scope + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "name=" + name + ", "
        + "customErrorTTLEnabled=" + customErrorTTLEnabled + ", "
        + "customErrorTTL=" + customErrorTTL + ", "
        + "customErrorTTLUnit=" + customErrorTTLUnit + ", "
        + "contentPack=" + contentPack + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DataAdapterApi) {
      DataAdapterApi that = (DataAdapterApi) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && (this.scope == null ? that.scope() == null : this.scope.equals(that.scope()))
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.name.equals(that.name())
          && (this.customErrorTTLEnabled == null ? that.customErrorTTLEnabled() == null : this.customErrorTTLEnabled.equals(that.customErrorTTLEnabled()))
          && (this.customErrorTTL == null ? that.customErrorTTL() == null : this.customErrorTTL.equals(that.customErrorTTL()))
          && (this.customErrorTTLUnit == null ? that.customErrorTTLUnit() == null : this.customErrorTTLUnit.equals(that.customErrorTTLUnit()))
          && (this.contentPack == null ? that.contentPack() == null : this.contentPack.equals(that.contentPack()))
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= (scope == null) ? 0 : scope.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (customErrorTTLEnabled == null) ? 0 : customErrorTTLEnabled.hashCode();
    h$ *= 1000003;
    h$ ^= (customErrorTTL == null) ? 0 : customErrorTTL.hashCode();
    h$ *= 1000003;
    h$ ^= (customErrorTTLUnit == null) ? 0 : customErrorTTLUnit.hashCode();
    h$ *= 1000003;
    h$ ^= (contentPack == null) ? 0 : contentPack.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  static class Builder extends DataAdapterApi.Builder {
    private String id;
    private String scope;
    private @NotEmpty String title;
    private String description;
    private @NotEmpty String name;
    private Boolean customErrorTTLEnabled;
    private Long customErrorTTL;
    private TimeUnit customErrorTTLUnit;
    private String contentPack;
    private @NotNull LookupDataAdapterConfiguration config;
    Builder() {
    }
    @Override
    public DataAdapterApi.Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }
    @Override
    public DataAdapterApi.Builder scope(String scope) {
      this.scope = scope;
      return this;
    }
    @Override
    public DataAdapterApi.Builder title(String title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public DataAdapterApi.Builder description(String description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public DataAdapterApi.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public DataAdapterApi.Builder customErrorTTLEnabled(@Nullable Boolean customErrorTTLEnabled) {
      this.customErrorTTLEnabled = customErrorTTLEnabled;
      return this;
    }
    @Override
    public DataAdapterApi.Builder customErrorTTL(@Nullable Long customErrorTTL) {
      this.customErrorTTL = customErrorTTL;
      return this;
    }
    @Override
    public DataAdapterApi.Builder customErrorTTLUnit(@Nullable TimeUnit customErrorTTLUnit) {
      this.customErrorTTLUnit = customErrorTTLUnit;
      return this;
    }
    @Override
    public DataAdapterApi.Builder contentPack(@Nullable String contentPack) {
      this.contentPack = contentPack;
      return this;
    }
    @Override
    public DataAdapterApi.Builder config(LookupDataAdapterConfiguration config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public DataAdapterApi build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DataAdapterApi(
          this.id,
          this.scope,
          this.title,
          this.description,
          this.name,
          this.customErrorTTLEnabled,
          this.customErrorTTL,
          this.customErrorTTLUnit,
          this.contentPack,
          this.config);
    }
  }

}
