package org.graylog2.rest.models.system.lookup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import org.graylog2.lookup.LookupDefaultValue;

final class AutoValue_LookupTableApi extends $AutoValue_LookupTableApi {
  AutoValue_LookupTableApi(String id, String scope, String title, String description, String name,
      String cacheId, String dataAdapterId, String contentPack, String defaultSingleValue,
      LookupDefaultValue.Type defaultSingleValueType, String defaultMultiValue,
      LookupDefaultValue.Type defaultMultiValueType) {
    super(id, scope, title, description, name, cacheId, dataAdapterId, contentPack, defaultSingleValue, defaultSingleValueType, defaultMultiValue, defaultMultiValueType);
  }

  @JsonIgnore
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  @Nullable
  public final String getScope() {
    return scope();
  }

  @JsonIgnore
  @NotEmpty
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  @NotEmpty
  public final String getName() {
    return name();
  }

  @JsonIgnore
  @NotEmpty
  public final String getCacheId() {
    return cacheId();
  }

  @JsonIgnore
  @NotEmpty
  public final String getDataAdapterId() {
    return dataAdapterId();
  }

  @JsonIgnore
  @Nullable
  public final String getContentPack() {
    return contentPack();
  }

  @JsonIgnore
  public final String getDefaultSingleValue() {
    return defaultSingleValue();
  }

  @JsonIgnore
  public final LookupDefaultValue.Type getDefaultSingleValueType() {
    return defaultSingleValueType();
  }

  @JsonIgnore
  public final String getDefaultMultiValue() {
    return defaultMultiValue();
  }

  @JsonIgnore
  public final LookupDefaultValue.Type getDefaultMultiValueType() {
    return defaultMultiValueType();
  }
}
