package org.graylog2.rest.models.tools.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_PageListResponse<T> extends PageListResponse<T> {

  private final String query;

  private final PaginatedList.PaginationInfo paginationInfo;

  private final long total;

  private final String sort;

  private final String order;

  private final List<T> elements;

  private final List<EntityAttribute> attributes;

  private final EntityDefaults defaults;

  $AutoValue_PageListResponse(
      @Nullable String query,
      PaginatedList.PaginationInfo paginationInfo,
      long total,
      @Nullable String sort,
      @Nullable String order,
      List<T> elements,
      List<EntityAttribute> attributes,
      EntityDefaults defaults) {
    this.query = query;
    if (paginationInfo == null) {
      throw new NullPointerException("Null paginationInfo");
    }
    this.paginationInfo = paginationInfo;
    this.total = total;
    this.sort = sort;
    this.order = order;
    if (elements == null) {
      throw new NullPointerException("Null elements");
    }
    this.elements = elements;
    if (attributes == null) {
      throw new NullPointerException("Null attributes");
    }
    this.attributes = attributes;
    if (defaults == null) {
      throw new NullPointerException("Null defaults");
    }
    this.defaults = defaults;
  }

  @Nullable
  @JsonProperty("query")
  @Override
  public String query() {
    return query;
  }

  @JsonProperty("pagination")
  @Override
  public PaginatedList.PaginationInfo paginationInfo() {
    return paginationInfo;
  }

  @JsonProperty("total")
  @Override
  public long total() {
    return total;
  }

  @Nullable
  @JsonProperty("sort")
  @Override
  public String sort() {
    return sort;
  }

  @Nullable
  @JsonProperty("order")
  @Override
  public String order() {
    return order;
  }

  @JsonProperty("elements")
  @Override
  public List<T> elements() {
    return elements;
  }

  @JsonProperty
  @Override
  public List<EntityAttribute> attributes() {
    return attributes;
  }

  @JsonProperty
  @Override
  public EntityDefaults defaults() {
    return defaults;
  }

  @Override
  public String toString() {
    return "PageListResponse{"
        + "query=" + query + ", "
        + "paginationInfo=" + paginationInfo + ", "
        + "total=" + total + ", "
        + "sort=" + sort + ", "
        + "order=" + order + ", "
        + "elements=" + elements + ", "
        + "attributes=" + attributes + ", "
        + "defaults=" + defaults
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PageListResponse) {
      PageListResponse<?> that = (PageListResponse<?>) o;
      return (this.query == null ? that.query() == null : this.query.equals(that.query()))
          && this.paginationInfo.equals(that.paginationInfo())
          && this.total == that.total()
          && (this.sort == null ? that.sort() == null : this.sort.equals(that.sort()))
          && (this.order == null ? that.order() == null : this.order.equals(that.order()))
          && this.elements.equals(that.elements())
          && this.attributes.equals(that.attributes())
          && this.defaults.equals(that.defaults());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (query == null) ? 0 : query.hashCode();
    h$ *= 1000003;
    h$ ^= paginationInfo.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((total >>> 32) ^ total);
    h$ *= 1000003;
    h$ ^= (sort == null) ? 0 : sort.hashCode();
    h$ *= 1000003;
    h$ ^= (order == null) ? 0 : order.hashCode();
    h$ *= 1000003;
    h$ ^= elements.hashCode();
    h$ *= 1000003;
    h$ ^= attributes.hashCode();
    h$ *= 1000003;
    h$ ^= defaults.hashCode();
    return h$;
  }

}
