package org.graylog2.rest.models.tools.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;

final class AutoValue_PageListResponse<T> extends $AutoValue_PageListResponse<T> {
  AutoValue_PageListResponse(String query, PaginatedList.PaginationInfo paginationInfo, long total,
      String sort, String order, List<T> elements, List<EntityAttribute> attributes,
      EntityDefaults defaults) {
    super(query, paginationInfo, total, sort, order, elements, attributes, defaults);
  }

  @JsonIgnore
  @Nullable
  public final String getQuery() {
    return query();
  }

  @JsonIgnore
  public final PaginatedList.PaginationInfo getPaginationInfo() {
    return paginationInfo();
  }

  @JsonIgnore
  public final long getTotal() {
    return total();
  }

  @JsonIgnore
  @Nullable
  public final String getSort() {
    return sort();
  }

  @JsonIgnore
  @Nullable
  public final String getOrder() {
    return order();
  }

  @JsonIgnore
  public final List<T> getElements() {
    return elements();
  }

  @JsonIgnore
  public final List<EntityAttribute> getAttributes() {
    return attributes();
  }

  @JsonIgnore
  public final EntityDefaults getDefaults() {
    return defaults();
  }
}
