package org.graylog2.rest.models.users.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_CreateUserRequest extends $AutoValue_CreateUserRequest {
  AutoValue_CreateUserRequest(String username, String password, String email, String firstName,
      String lastName, List<String> permissions, String timezone, Long sessionTimeoutMs,
      Startpage startpage, List<String> roles, boolean isServiceAccount) {
    super(username, password, email, firstName, lastName, permissions, timezone, sessionTimeoutMs, startpage, roles, isServiceAccount);
  }

  @JsonIgnore
  public final String getUsername() {
    return username();
  }

  @JsonIgnore
  public final String getPassword() {
    return password();
  }

  @JsonIgnore
  public final String getEmail() {
    return email();
  }

  @JsonIgnore
  public final String getFirstName() {
    return firstName();
  }

  @JsonIgnore
  public final String getLastName() {
    return lastName();
  }

  @JsonIgnore
  public final List<String> getPermissions() {
    return permissions();
  }

  @JsonIgnore
  @Nullable
  public final String getTimezone() {
    return timezone();
  }

  @JsonIgnore
  @Nullable
  public final Long getSessionTimeoutMs() {
    return sessionTimeoutMs();
  }

  @JsonIgnore
  @Nullable
  public final Startpage getStartpage() {
    return startpage();
  }

  @JsonIgnore
  @Nullable
  public final List<String> getRoles() {
    return roles();
  }

  @JsonIgnore
  public final boolean isIsServiceAccount() {
    return isServiceAccount();
  }
}
