package org.graylog2.rest.resources.system.indexer.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexSetUpdateRequest extends IndexSetUpdateRequest {

  private final @NotBlank String title;

  private final String description;

  private final boolean isWritable;

  private final @Min(1L) int shards;

  private final @Min(0L) int replicas;

  private final @NotNull String rotationStrategyClass;

  private final @NotNull RotationStrategyConfig rotationStrategy;

  private final @NotNull String retentionStrategyClass;

  private final @NotNull RetentionStrategyConfig retentionStrategy;

  private final @Min(1L) int indexOptimizationMaxNumSegments;

  private final boolean indexOptimizationDisabled;

  private final Duration fieldTypeRefreshInterval;

  AutoValue_IndexSetUpdateRequest(
      @NotBlank String title,
      @Nullable String description,
      boolean isWritable,
      @Min(1L) int shards,
      @Min(0L) int replicas,
      @NotNull String rotationStrategyClass,
      @NotNull RotationStrategyConfig rotationStrategy,
      @NotNull String retentionStrategyClass,
      @NotNull RetentionStrategyConfig retentionStrategy,
      @Min(1L) int indexOptimizationMaxNumSegments,
      boolean indexOptimizationDisabled,
      Duration fieldTypeRefreshInterval) {
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    this.description = description;
    this.isWritable = isWritable;
    this.shards = shards;
    this.replicas = replicas;
    if (rotationStrategyClass == null) {
      throw new NullPointerException("Null rotationStrategyClass");
    }
    this.rotationStrategyClass = rotationStrategyClass;
    if (rotationStrategy == null) {
      throw new NullPointerException("Null rotationStrategy");
    }
    this.rotationStrategy = rotationStrategy;
    if (retentionStrategyClass == null) {
      throw new NullPointerException("Null retentionStrategyClass");
    }
    this.retentionStrategyClass = retentionStrategyClass;
    if (retentionStrategy == null) {
      throw new NullPointerException("Null retentionStrategy");
    }
    this.retentionStrategy = retentionStrategy;
    this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
    this.indexOptimizationDisabled = indexOptimizationDisabled;
    if (fieldTypeRefreshInterval == null) {
      throw new NullPointerException("Null fieldTypeRefreshInterval");
    }
    this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
  }

  @JsonProperty("title")
  @Override
  public @NotBlank String title() {
    return title;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("writable")
  @Override
  public boolean isWritable() {
    return isWritable;
  }

  @JsonProperty("shards")
  @Override
  public @Min(1L) int shards() {
    return shards;
  }

  @JsonProperty("replicas")
  @Override
  public @Min(0L) int replicas() {
    return replicas;
  }

  @JsonProperty("rotation_strategy_class")
  @Override
  public @NotNull String rotationStrategyClass() {
    return rotationStrategyClass;
  }

  @JsonProperty("rotation_strategy")
  @Override
  public @NotNull RotationStrategyConfig rotationStrategy() {
    return rotationStrategy;
  }

  @JsonProperty("retention_strategy_class")
  @Override
  public @NotNull String retentionStrategyClass() {
    return retentionStrategyClass;
  }

  @JsonProperty("retention_strategy")
  @Override
  public @NotNull RetentionStrategyConfig retentionStrategy() {
    return retentionStrategy;
  }

  @JsonProperty("index_optimization_max_num_segments")
  @Override
  public @Min(1L) int indexOptimizationMaxNumSegments() {
    return indexOptimizationMaxNumSegments;
  }

  @JsonProperty("index_optimization_disabled")
  @Override
  public boolean indexOptimizationDisabled() {
    return indexOptimizationDisabled;
  }

  @JsonProperty("field_type_refresh_interval")
  @Override
  public Duration fieldTypeRefreshInterval() {
    return fieldTypeRefreshInterval;
  }

  @Override
  public String toString() {
    return "IndexSetUpdateRequest{"
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "isWritable=" + isWritable + ", "
        + "shards=" + shards + ", "
        + "replicas=" + replicas + ", "
        + "rotationStrategyClass=" + rotationStrategyClass + ", "
        + "rotationStrategy=" + rotationStrategy + ", "
        + "retentionStrategyClass=" + retentionStrategyClass + ", "
        + "retentionStrategy=" + retentionStrategy + ", "
        + "indexOptimizationMaxNumSegments=" + indexOptimizationMaxNumSegments + ", "
        + "indexOptimizationDisabled=" + indexOptimizationDisabled + ", "
        + "fieldTypeRefreshInterval=" + fieldTypeRefreshInterval
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexSetUpdateRequest) {
      IndexSetUpdateRequest that = (IndexSetUpdateRequest) o;
      return this.title.equals(that.title())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.isWritable == that.isWritable()
          && this.shards == that.shards()
          && this.replicas == that.replicas()
          && this.rotationStrategyClass.equals(that.rotationStrategyClass())
          && this.rotationStrategy.equals(that.rotationStrategy())
          && this.retentionStrategyClass.equals(that.retentionStrategyClass())
          && this.retentionStrategy.equals(that.retentionStrategy())
          && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments()
          && this.indexOptimizationDisabled == that.indexOptimizationDisabled()
          && this.fieldTypeRefreshInterval.equals(that.fieldTypeRefreshInterval());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= isWritable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= shards;
    h$ *= 1000003;
    h$ ^= replicas;
    h$ *= 1000003;
    h$ ^= rotationStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= rotationStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategyClass.hashCode();
    h$ *= 1000003;
    h$ ^= retentionStrategy.hashCode();
    h$ *= 1000003;
    h$ ^= indexOptimizationMaxNumSegments;
    h$ *= 1000003;
    h$ ^= indexOptimizationDisabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= fieldTypeRefreshInterval.hashCode();
    return h$;
  }

}
