package org.graylog2.rest.resources.system.responses;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import org.joda.time.Duration;

final class AutoValue_KafkaJournalConfigurationSummary extends $AutoValue_KafkaJournalConfigurationSummary {
  AutoValue_KafkaJournalConfigurationSummary(Path directory, long segmentSize, Duration segmentAge,
      long maxSize, Duration maxAge, long flushInterval, Duration flushAge) {
    super(directory, segmentSize, segmentAge, maxSize, maxAge, flushInterval, flushAge);
  }

  @JsonIgnore
  public final Path getDirectory() {
    return directory();
  }

  @JsonIgnore
  public final long getSegmentSize() {
    return segmentSize();
  }

  @JsonIgnore
  @JsonFormat(
      shape = JsonFormat.Shape.NUMBER
  )
  public final Duration getSegmentAge() {
    return segmentAge();
  }

  @JsonIgnore
  public final long getMaxSize() {
    return maxSize();
  }

  @JsonIgnore
  @JsonFormat(
      shape = JsonFormat.Shape.NUMBER
  )
  public final Duration getMaxAge() {
    return maxAge();
  }

  @JsonIgnore
  public final long getFlushInterval() {
    return flushInterval();
  }

  @JsonIgnore
  @JsonFormat(
      shape = JsonFormat.Shape.NUMBER
  )
  public final Duration getFlushAge() {
    return flushAge();
  }
}
