package org.graylog2.system.processing;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProcessingStatusDto_JournalInfo extends ProcessingStatusDto.JournalInfo {

  private final long uncommittedEntries;

  private final double readMessages1mRate;

  private final double writtenMessages1mRate;

  private final boolean journalEnabled;

  private AutoValue_ProcessingStatusDto_JournalInfo(
      long uncommittedEntries,
      double readMessages1mRate,
      double writtenMessages1mRate,
      boolean journalEnabled) {
    this.uncommittedEntries = uncommittedEntries;
    this.readMessages1mRate = readMessages1mRate;
    this.writtenMessages1mRate = writtenMessages1mRate;
    this.journalEnabled = journalEnabled;
  }

  @JsonProperty("uncommitted_entries")
  @Override
  public long uncommittedEntries() {
    return uncommittedEntries;
  }

  @JsonProperty("read_messages_1m_rate")
  @Override
  public double readMessages1mRate() {
    return readMessages1mRate;
  }

  @JsonProperty("written_messages_1m_rate")
  @Override
  public double writtenMessages1mRate() {
    return writtenMessages1mRate;
  }

  @JsonProperty("journal_enabled")
  @Override
  public boolean journalEnabled() {
    return journalEnabled;
  }

  @Override
  public String toString() {
    return "JournalInfo{"
        + "uncommittedEntries=" + uncommittedEntries + ", "
        + "readMessages1mRate=" + readMessages1mRate + ", "
        + "writtenMessages1mRate=" + writtenMessages1mRate + ", "
        + "journalEnabled=" + journalEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProcessingStatusDto.JournalInfo) {
      ProcessingStatusDto.JournalInfo that = (ProcessingStatusDto.JournalInfo) o;
      return this.uncommittedEntries == that.uncommittedEntries()
          && Double.doubleToLongBits(this.readMessages1mRate) == Double.doubleToLongBits(that.readMessages1mRate())
          && Double.doubleToLongBits(this.writtenMessages1mRate) == Double.doubleToLongBits(that.writtenMessages1mRate())
          && this.journalEnabled == that.journalEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((uncommittedEntries >>> 32) ^ uncommittedEntries);
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(readMessages1mRate) >>> 32) ^ Double.doubleToLongBits(readMessages1mRate));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(writtenMessages1mRate) >>> 32) ^ Double.doubleToLongBits(writtenMessages1mRate));
    h$ *= 1000003;
    h$ ^= journalEnabled ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends ProcessingStatusDto.JournalInfo.Builder {
    private Long uncommittedEntries;
    private Double readMessages1mRate;
    private Double writtenMessages1mRate;
    private Boolean journalEnabled;
    Builder() {
    }
    @Override
    public ProcessingStatusDto.JournalInfo.Builder uncommittedEntries(long uncommittedEntries) {
      this.uncommittedEntries = uncommittedEntries;
      return this;
    }
    @Override
    public ProcessingStatusDto.JournalInfo.Builder readMessages1mRate(double readMessages1mRate) {
      this.readMessages1mRate = readMessages1mRate;
      return this;
    }
    @Override
    public ProcessingStatusDto.JournalInfo.Builder writtenMessages1mRate(double writtenMessages1mRate) {
      this.writtenMessages1mRate = writtenMessages1mRate;
      return this;
    }
    @Override
    public ProcessingStatusDto.JournalInfo.Builder journalEnabled(boolean journalEnabled) {
      this.journalEnabled = journalEnabled;
      return this;
    }
    @Override
    public ProcessingStatusDto.JournalInfo build() {
      String missing = "";
      if (this.uncommittedEntries == null) {
        missing += " uncommittedEntries";
      }
      if (this.readMessages1mRate == null) {
        missing += " readMessages1mRate";
      }
      if (this.writtenMessages1mRate == null) {
        missing += " writtenMessages1mRate";
      }
      if (this.journalEnabled == null) {
        missing += " journalEnabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProcessingStatusDto_JournalInfo(
          this.uncommittedEntries,
          this.readMessages1mRate,
          this.writtenMessages1mRate,
          this.journalEnabled);
    }
  }

}
