package org.graylog2.system.stats.elasticsearch;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NodeInfo extends NodeInfo {

  private final String version;

  private final Object os;

  private final Long jvmMemHeapMaxInBytes;

  private final List<String> roles;

  private AutoValue_NodeInfo(
      String version,
      Object os,
      Long jvmMemHeapMaxInBytes,
      List<String> roles) {
    this.version = version;
    this.os = os;
    this.jvmMemHeapMaxInBytes = jvmMemHeapMaxInBytes;
    this.roles = roles;
  }

  @JsonProperty
  @Override
  public String version() {
    return version;
  }

  @JsonProperty
  @Override
  public Object os() {
    return os;
  }

  @JsonProperty
  @Override
  public Long jvmMemHeapMaxInBytes() {
    return jvmMemHeapMaxInBytes;
  }

  @JsonProperty
  @Override
  public List<String> roles() {
    return roles;
  }

  @Override
  public String toString() {
    return "NodeInfo{"
        + "version=" + version + ", "
        + "os=" + os + ", "
        + "jvmMemHeapMaxInBytes=" + jvmMemHeapMaxInBytes + ", "
        + "roles=" + roles
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NodeInfo) {
      NodeInfo that = (NodeInfo) o;
      return this.version.equals(that.version())
          && this.os.equals(that.os())
          && this.jvmMemHeapMaxInBytes.equals(that.jvmMemHeapMaxInBytes())
          && this.roles.equals(that.roles());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= version.hashCode();
    h$ *= 1000003;
    h$ ^= os.hashCode();
    h$ *= 1000003;
    h$ ^= jvmMemHeapMaxInBytes.hashCode();
    h$ *= 1000003;
    h$ ^= roles.hashCode();
    return h$;
  }

  static final class Builder extends NodeInfo.Builder {
    private String version;
    private Object os;
    private Long jvmMemHeapMaxInBytes;
    private List<String> roles;
    Builder() {
    }
    @Override
    public NodeInfo.Builder version(String version) {
      if (version == null) {
        throw new NullPointerException("Null version");
      }
      this.version = version;
      return this;
    }
    @Override
    public NodeInfo.Builder os(Object os) {
      if (os == null) {
        throw new NullPointerException("Null os");
      }
      this.os = os;
      return this;
    }
    @Override
    public NodeInfo.Builder jvmMemHeapMaxInBytes(Long jvmMemHeapMaxInBytes) {
      if (jvmMemHeapMaxInBytes == null) {
        throw new NullPointerException("Null jvmMemHeapMaxInBytes");
      }
      this.jvmMemHeapMaxInBytes = jvmMemHeapMaxInBytes;
      return this;
    }
    @Override
    public NodeInfo.Builder roles(List<String> roles) {
      if (roles == null) {
        throw new NullPointerException("Null roles");
      }
      this.roles = roles;
      return this;
    }
    @Override
    public NodeInfo build() {
      String missing = "";
      if (this.version == null) {
        missing += " version";
      }
      if (this.os == null) {
        missing += " os";
      }
      if (this.jvmMemHeapMaxInBytes == null) {
        missing += " jvmMemHeapMaxInBytes";
      }
      if (this.roles == null) {
        missing += " roles";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_NodeInfo(
          this.version,
          this.os,
          this.jvmMemHeapMaxInBytes,
          this.roles);
    }
  }

}
