package org.graylog2.system.stats.mongo;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_DatabaseStats extends DatabaseStats {

  private final String db;

  private final long collections;

  private final long objects;

  private final double avgObjSize;

  private final long dataSize;

  private final long storageSize;

  private final Long numExtents;

  private final long indexes;

  private final long indexSize;

  private final Long fileSize;

  private final Long nsSizeMB;

  private final DatabaseStats.ExtentFreeList extentFreeList;

  private final DatabaseStats.DataFileVersion dataFileVersion;

  $AutoValue_DatabaseStats(
      String db,
      long collections,
      long objects,
      double avgObjSize,
      long dataSize,
      long storageSize,
      @Nullable Long numExtents,
      long indexes,
      long indexSize,
      @Nullable Long fileSize,
      @Nullable Long nsSizeMB,
      @Nullable DatabaseStats.ExtentFreeList extentFreeList,
      @Nullable DatabaseStats.DataFileVersion dataFileVersion) {
    if (db == null) {
      throw new NullPointerException("Null db");
    }
    this.db = db;
    this.collections = collections;
    this.objects = objects;
    this.avgObjSize = avgObjSize;
    this.dataSize = dataSize;
    this.storageSize = storageSize;
    this.numExtents = numExtents;
    this.indexes = indexes;
    this.indexSize = indexSize;
    this.fileSize = fileSize;
    this.nsSizeMB = nsSizeMB;
    this.extentFreeList = extentFreeList;
    this.dataFileVersion = dataFileVersion;
  }

  @JsonProperty
  @Override
  public String db() {
    return db;
  }

  @JsonProperty
  @Override
  public long collections() {
    return collections;
  }

  @JsonProperty
  @Override
  public long objects() {
    return objects;
  }

  @JsonProperty
  @Override
  public double avgObjSize() {
    return avgObjSize;
  }

  @JsonProperty
  @Override
  public long dataSize() {
    return dataSize;
  }

  @JsonProperty
  @Override
  public long storageSize() {
    return storageSize;
  }

  @JsonProperty
  @Nullable
  @Override
  public Long numExtents() {
    return numExtents;
  }

  @JsonProperty
  @Override
  public long indexes() {
    return indexes;
  }

  @JsonProperty
  @Override
  public long indexSize() {
    return indexSize;
  }

  @JsonProperty
  @Nullable
  @Override
  public Long fileSize() {
    return fileSize;
  }

  @JsonProperty
  @Nullable
  @Override
  public Long nsSizeMB() {
    return nsSizeMB;
  }

  @JsonProperty
  @Nullable
  @Override
  public DatabaseStats.ExtentFreeList extentFreeList() {
    return extentFreeList;
  }

  @JsonProperty
  @Nullable
  @Override
  public DatabaseStats.DataFileVersion dataFileVersion() {
    return dataFileVersion;
  }

  @Override
  public String toString() {
    return "DatabaseStats{"
        + "db=" + db + ", "
        + "collections=" + collections + ", "
        + "objects=" + objects + ", "
        + "avgObjSize=" + avgObjSize + ", "
        + "dataSize=" + dataSize + ", "
        + "storageSize=" + storageSize + ", "
        + "numExtents=" + numExtents + ", "
        + "indexes=" + indexes + ", "
        + "indexSize=" + indexSize + ", "
        + "fileSize=" + fileSize + ", "
        + "nsSizeMB=" + nsSizeMB + ", "
        + "extentFreeList=" + extentFreeList + ", "
        + "dataFileVersion=" + dataFileVersion
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatabaseStats) {
      DatabaseStats that = (DatabaseStats) o;
      return this.db.equals(that.db())
          && this.collections == that.collections()
          && this.objects == that.objects()
          && Double.doubleToLongBits(this.avgObjSize) == Double.doubleToLongBits(that.avgObjSize())
          && this.dataSize == that.dataSize()
          && this.storageSize == that.storageSize()
          && (this.numExtents == null ? that.numExtents() == null : this.numExtents.equals(that.numExtents()))
          && this.indexes == that.indexes()
          && this.indexSize == that.indexSize()
          && (this.fileSize == null ? that.fileSize() == null : this.fileSize.equals(that.fileSize()))
          && (this.nsSizeMB == null ? that.nsSizeMB() == null : this.nsSizeMB.equals(that.nsSizeMB()))
          && (this.extentFreeList == null ? that.extentFreeList() == null : this.extentFreeList.equals(that.extentFreeList()))
          && (this.dataFileVersion == null ? that.dataFileVersion() == null : this.dataFileVersion.equals(that.dataFileVersion()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= db.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((collections >>> 32) ^ collections);
    h$ *= 1000003;
    h$ ^= (int) ((objects >>> 32) ^ objects);
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(avgObjSize) >>> 32) ^ Double.doubleToLongBits(avgObjSize));
    h$ *= 1000003;
    h$ ^= (int) ((dataSize >>> 32) ^ dataSize);
    h$ *= 1000003;
    h$ ^= (int) ((storageSize >>> 32) ^ storageSize);
    h$ *= 1000003;
    h$ ^= (numExtents == null) ? 0 : numExtents.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((indexes >>> 32) ^ indexes);
    h$ *= 1000003;
    h$ ^= (int) ((indexSize >>> 32) ^ indexSize);
    h$ *= 1000003;
    h$ ^= (fileSize == null) ? 0 : fileSize.hashCode();
    h$ *= 1000003;
    h$ ^= (nsSizeMB == null) ? 0 : nsSizeMB.hashCode();
    h$ *= 1000003;
    h$ ^= (extentFreeList == null) ? 0 : extentFreeList.hashCode();
    h$ *= 1000003;
    h$ ^= (dataFileVersion == null) ? 0 : dataFileVersion.hashCode();
    return h$;
  }

}
